// -*- c++ -*-
/***************************************************************************
                          levelfct.h  -  description
                             -------------------
    begin                : thu sept 19 21:19:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _LEVELFCT_H_
#define _LEVELFCT_H_

#include "levelobject.h"
#include <list>

class LvlFct
{
public:
  static LvlFct* Build(QDomElement fct, Level *l);
  LvlFct();
  LvlFct(QDomElement fct, Level *l);
  virtual ~LvlFct();
  virtual int Eval() = 0;
protected:
  QDomElement node_fct;
  Level *level;
};

class LvlFctRef : public LvlFct
{
public:
  LvlFctRef(QDomElement fct, Level *l);
  virtual int Eval();
protected:
  QString name;
};

class LvlFctRandom : public LvlFct
{
public:
  LvlFctRandom(QDomElement fct, Level *l);
  virtual int Eval();
protected:
  int min,max;
};

class LvlFctTurn : public LvlFct
{
public:
  LvlFctTurn(QDomElement fct, Level *l);
  virtual int Eval();
};

class LvlFctBlockedEntry : public LvlFct
{
public:
  LvlFctBlockedEntry(QDomElement fct, Level *l);
  virtual int Eval();
};

class LvlFctLeaved : public LvlFct
{
public:
  LvlFctLeaved(QDomElement fct, Level *l);
  virtual int Eval();
protected:
  LvlObjectType lvltype;
};

class LvlFctAP : public LvlFct
{
public:
  LvlFctAP(QDomElement fct, Level *l);
  virtual int Eval();
protected:
  enum operations
  {
    max,
    min,
    mean,
    sum,
    prod
  };
  QString ref_name;
  operations op;
};

class LvlFctTaken : public LvlFct
{
public:
  LvlFctTaken(QDomElement fct, Level *l);
  virtual int Eval();
protected:
  QString ref_name;
};

class LvlFctSize : public LvlFct
{
public:
  LvlFctSize(QDomElement fct, Level *l);
  virtual int Eval();
protected:
  QString ref_name;
};

class LvlFctDead : public LvlFct
{
public:
  LvlFctDead(QDomElement fct, Level *l);
  virtual int Eval();
protected:
  LvlObjectType lvltype;
};

class LvlFctValue : public LvlFct
{
public:
  LvlFctValue(QDomElement fct, Level *l);
  virtual int Eval();
protected:
  int number;
};

class LvlFctOps : public LvlFct
{
public:
  LvlFctOps(QDomElement fct, Level *l);
  ~LvlFctOps();
protected:
  std::list<LvlFct*> args;
};

class LvlFctSum : public LvlFctOps
{
public:
  LvlFctSum(QDomElement fct, Level *l);
  virtual int Eval();
};

class LvlFctProduct : public LvlFctOps
{
public:
  LvlFctProduct(QDomElement fct, Level *l);
  virtual int Eval();
};

#endif
