// -*- c++ -*-
/***************************************************************************
                          qcommandline.h  -  description
                             -------------------
    begin                : ven avr 19 13:20:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _QCOMMANDLINE_H_
#define _QCOMMANDLINE_H_

/*
  QCommandLine is the GUI interface for player interaction.
  This class takes all the input of the player and if it's a command execute it

*/

enum QState { Q_NONE, Q_DIRECTION, Q_LEVEL, Q_BOOLEAN, Q_ENDOFGAME, Q_NEWGAME, 
	      Q_LEVELINFO, Q_FILENAME, Q_POPUPMSG, Q_SMTPINFOS, Q_IPADRESS,
	      Q_NETWORK };

#include <qthread.h>

#include "guicommandline.h"

class QMultiLineEdit;
class QLineEdit;
class QLabel;
class QPushButton;
class QInterfaceImpl;
class QString;

class QCreature;
class QPixmapBoard;
class QDataStoring;

class QCommandLine : public GUICommandLine, public QThread
{
public:
  QCommandLine(QPixmapBoard *qboard, QCreature *qcrea, QInterfaceImpl *main);
  ~QCommandLine(void);
  
  virtual void run(void); // Qthread support.
  void endOfExecution(void);

  QState getState(void);

  void getCommand(QString command);
  void Write(QString w, bool isCommand=false);

  void ResizeBoard(int x, int y);
  void DrawInterface(void);

  void GUIDrawInterface(void);
  void setObjectButtonsVisible(bool vis);
  void ClearListCreatures(void);
  void GUIClearListCreatures(void);
  void ClearInfoPanel(void);
  void GUI_ClearInfoPanel(void);
  
  pair<Direction,bool> GetDirection(QString txt, bool enableReuse=true);
  void GUI_GetDirection(void);
  QString GetLevelToPlay(void);
  void GUI_GetLevelToPlay(void);
  int GetCase(set<int> *cases, QString txt);
  pair<int,pair<Direction,bool> > GetCaseAndDirection(set<int> *cs,QString txt,
						      bool enableReuse=true);
  bool GetYesOrNo(QString txt);
  void GUI_GetYesOrNo(void);
  void endOfGame(QString txt);
  QString GetFilename(bool PbemExt=false);
  void GUI_GetFilename(void);
  void GUI_EndOfGame(void);
  void printLevelInfo(QString &tit, QString &auth, QString &nar, QString &obj, 
		      QString &forc, QString &cond);
  void printLevelInfo(void);
  void GUI_PrintLevelInfo(void);
  void printPopupMessage(QString msg);
  void GUI_PrintPopupMessage(void);
  gameType GetGameType(bool *heurisTurn, int *cheat);
  void GUI_GetGameType();
  void CenterView(int caseId);
  void GetSmtpInfos(SmtpInfo *inf);
  void GUI_GetSmtpInfos(void);
  QString GetIPAdress();
  void GUI_GetIPAdress();

  void boardClick(int xcoord, int ycoord, bool isLeftButton);
  void GetEvent();
  void PostNetworkCommand();
  void GetNetworkCommand();

  void Game_Wait(void);
  void Game_Wake(void);

private:
  QInterfaceImpl *qmain;

  QMultiLineEdit *qinfo;
  QLabel *qview;
  QLabel *qsel;
  QMultiLineEdit *qlist;
  QPushButton *qViewButton;
  QLabel *qturninfo;

  QWaitCondition gameLock;
  QMutex gameMutex;

  bool guiRunning;
  QString currCmd;

  QState qstate;
  QString gui_msg;
  Direction gui_dir;
  QString gui_str;
  bool gui_res;
  SmtpInfo *gui_info;
  QString leveltitle, levelauthor, levelnarration, levelobjectives,
    levelforces, levelcond;
  bool *heuris;
  int *cheat;
  gameType gType;
};

#include <qvariant.h>
#include <qdialog.h>
class QVBoxLayout; 
class QHBoxLayout; 
class QLabel;
class QLineEdit;

class IPAdressDialog : public QDialog
{ 
  Q_OBJECT
public:
  IPAdressDialog(QWidget *parent, QString *msg);
  
  QLabel* label;
  QLineEdit* ip;
  QPushButton* ok;
public slots:
  virtual void clickOk();
protected:
  QVBoxLayout* Form1Layout;
  QHBoxLayout* Layout1;
  QString *msg;
};

#endif
