/***************************************************************************
                          qcreature.cpp  -  description
                             -------------------
    begin                : sam mai 04 16:36:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef _WIN32
#pragma warning (disable : 4786)
#endif

#include <sstream>
#include <cstdio>
using namespace std;

#include <qmultilineedit.h>
#include <qlabel.h>
#include <qtextstream.h>

#include "qcreature.h"

#include "qinterfaceimpl.h"
#include "qpixmapboard.h"
#include "qthemeengine.h"
#include "qcommandline.h"
#include "gamemanager.h"

QCreature::QCreature(QInterfaceImpl *m)
  : GUICreature(), main(m)
{
  theme = main->bsv->pb->getThemeEngine();
}

QCreature::~QCreature(void) 
{}

void QCreature::printInfo(EntryZone *zone, bool isSelected, int location)
{
  // For the entryzone, we print on the qinfo panel list of creatures if
  //  this is the first time the case is on onView.
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "EntryZone [" << zone->getXPosition() << "," << zone->getYPosition();
  res << "] with " << board->getObject(zone->getPosition())->size()-1 << " creatures :";
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(Door *door, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "Door : " << _getStringPosition(door);
  if (door->state == OPEN)
    res << ", door open.";
  else
    res << ", door closed.";
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(Bulkhead *bulk, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);;
  res << "Bulkhead : " << _getStringPosition(bulk);
  if (!bulk->stateCanBeOpened)
    res << ", can never be opened";
  if (!bulk->stateCanBeClosed)
    res << ", can never be closed";

  if (bulk->state == OPEN)
    res << ", currently open.";
  else
    res << ", currently closed.";
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(Flame *fl, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "Flame : " << _getStringPosition(fl);
  res << ", nb of flames " << fl->nbFlames;

  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(BolterMarine *crea, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "Marine : " << _getStringPosition(crea) << ", ";
  res << "dir " << dir2string(crea->orientation);
  res << _getStringOverwatch(crea);

  if (isSelected) {
    int realActionPts = crea->actionPts - *(crea->cmdPts);
    if (realActionPts < 0)
      realActionPts = 0;
    
    res << ", " << realActionPts << " APs, " << *(crea->cmdPts) << "CPs"; 
  }
  else {
    res << ", " << crea->actionPts << " APs, " << *(crea->cmdPts) << "CPs";
  }
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(Sergeant *crea, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "Sergeant : " << _getStringPosition(crea) << ", ";
  res << "dir " << dir2string(crea->orientation);
  res << _getStringOverwatch(crea);

  if (isSelected) {
    int realActionPts = crea->actionPts - *(crea->cmdPts);
    if (realActionPts < 0)
      realActionPts = 0;
    
    res << ", " << realActionPts << " APs, " << *(crea->cmdPts) << " CPs";
  }
  else {
    res << ", " << crea->actionPts << " APs, " << *(crea->cmdPts) << " CPs";
  }
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(FlamerMarine *crea, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "Flamer : " << _getStringPosition(crea) << ", ";
  res << "dir " << dir2string(crea->orientation);
  res << ", ammo " << crea->ammunition;
  if (crea->charger)
    res << "+12";

  if (isSelected) {
    int realActionPts = crea->actionPts - *(crea->cmdPts);
    if (realActionPts < 0)
      realActionPts = 0;
    
    res << ", " << realActionPts << " APs, " << *(crea->cmdPts) << " CPs";
  }
  else {
    res << ", " << crea->actionPts << " APs, " << *(crea->cmdPts) << " CPs";
  }
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(Genestealer *crea, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "Genestealer : " << _getStringPosition(crea);
  res << ", dir " << dir2string(crea->orientation);
  res << ", " << crea->actionPts << " APs";
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(Blip *crea, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str, IO_WriteOnly);
  res << "Blip : " << _getStringPosition(crea);
  res << ", " << crea->actionPts << " APs";
  if (crea->currentTurn==GENESTEALER_TURN && !man->isInReplayMode())
    res << ", nb gen : " << crea->nbGen;
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(ModuleCAT *crea, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "CAT Module : " << _getStringPosition(crea);
  res << ", " << crea->actionPts << " APs";
  if (crea->isTaken)
    res << ", taken.";
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(Exit *crea, bool isSelected, int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "Exit square on " <<_getStringPosition(crea);
  res << ", already out : ";
  for (map<ObjectType, list<int> >::iterator it=crea->out.begin();
       it!=crea->out.end();it++){
    QString type;
    switch(it->first) {
    case BLIP: type="Blip"; break;
    case GENESTEALER: type="Genestealer"; break;
    case SERGEANT: type="Sergeant"; break;
    case BOLTERMARINE: type="Bolter marine"; break;
    case FLAMER: type="Flamer marine"; break;
    case CAT: type="CAT"; break;
    default: type="don't know";
    }
    for (list<int>::iterator ite=it->second.begin(); 
	 ite!=it->second.end(); ite++) {
      res << endl << type << ", id " << *ite;
    }
  }

  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printInfo(ExtensibleObject *crea, bool isSelected,int location)
{
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << crea->desc << " : " << _getStringPosition(crea);
  if (crea->isTaken)
    res << ", taken ";
  if (crea->stateIsShootable>1)
    res << ", still " << crea->stateIsShootable << " shots to kill";
  switch (location) {
  case 0:
    main->cmd->postEvent(main, new WriteCustomEvent(1000,str));
    break;
  case 1:
    main->cmd->postEvent(main, new WriteCustomEvent(1001,str));
    break;
  case 2:
    main->cmd->postEvent(main, new WriteCustomEvent(1002,str));
    break;
  case 3:
    main->cmd->postEvent(main, new WriteCustomEvent(1003,str));
    break;
  }
}

void QCreature::printDetailZoneInfo(EntryZone *ez) {printInfo(ez, false, 0);}

void QCreature::Message(QString msg)
{
  main->cmd->postEvent(main, new WriteCustomEvent(1000,msg));
}

QString QCreature::_getStringPosition(Object *obj) {
  QString str;
  QTextStream res(&str,IO_WriteOnly);
  res << "[" << obj->getXPosition() << "," << obj->getYPosition() << "]";  
  return str;
}

QString QCreature::_getStringOverwatch(BolterMarine *crea)
{
  if (crea->history==OVERWATCH)
    return QString(", overwatch");
  if (crea->jammed)
    return QString(", jammed");
  return "";
}

void * QCreature::getPixmap(BolterMarine *crea, bool big) 
{ return theme->getMarine(big,crea->orientation); }

void * QCreature::getPixmap(Sergeant *crea, bool big) 
{ return theme->getSergeant(big,crea->orientation); }

void * QCreature::getPixmap(FlamerMarine *crea, bool big) 
{ return theme->getFlamer(big, crea->orientation); }

void * QCreature::getPixmap(Genestealer *crea, bool big) 
{ return theme->getGenestealer(big, crea->orientation); }

void * QCreature::getPixmap(Door *crea, bool big) 
{ return theme->getDoor(big, crea->state, crea->isVertical); }

void * QCreature::getPixmap(Bulkhead *crea, bool big) 
{ return theme->getBulkhead(big, crea->state, crea->isVertical); }

void * QCreature::getPixmap(Blip *crea, bool big) 
{ return theme->getBlip(big); }

void * QCreature::getPixmap(Flame *crea, bool big)
{ return theme->getFlame(big); }

void * QCreature::getPixmap(EntryZone *crea, bool big) 
{ return theme->getEntryZone(big, crea->graphicalDir); }

void * QCreature::getPixmap(Exit *crea, bool big) 
{ return theme->getExit(big, crea->graphicalDir); }

void * QCreature::getPixmap(ModuleCAT *crea, bool big) 
{ return theme->getModuleCAT(big); }

void * QCreature::getPixmap(ExtensibleObject *crea, bool big) 
{ return theme->getExtensible(big, crea->graphic); }
