/***************************************************************************
                          qcreature.h  -  description
                             -------------------
    begin                : sam mai 04 16:35:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _QCREATURE_H_
#define _QCREATURE_H_

#include "creature.h"
#include "guicreature.h"

class QInterfaceImpl;
class QThemeEngine;
class QPixmap;

class QCreature : public GUICreature {
public:
  QCreature(QInterfaceImpl *main);
  virtual ~QCreature(void);

  void printInfo(BolterMarine *crea, bool isSelected, int location=0);
  void printInfo(Sergeant *crea, bool isSelected, int location=0);
  void printInfo(FlamerMarine *crea, bool isSelected, int location=0);
  void printInfo(Genestealer *crea, bool isSelected, int location=0);
  void printInfo(Blip *crea, bool isSelected, int location=0);  
  void printInfo(Door *door, bool isSelected, int location=0);
  void printInfo(Bulkhead *bulk, bool isSelected, int location=0);
  void printInfo(Flame *fl, bool isSelected, int location=0);
  void printInfo(EntryZone *zone, bool isSelected, int location=0);
  void printInfo(ModuleCAT *mae, bool isSelected, int location=0);
  void printInfo(Exit *exit, bool isSelected, int loc=0);
  void printInfo(ExtensibleObject *ext, bool isSelected, int loc=0);

  void printDetailZoneInfo(EntryZone *ez);

  void * getPixmap(BolterMarine *crea, bool big);
  void * getPixmap(Sergeant *crea, bool big);
  void * getPixmap(FlamerMarine *crea, bool big);
  void * getPixmap(Genestealer *crea, bool big);
  void * getPixmap(Blip *crea, bool big);
  void * getPixmap(Door *crea, bool big);
  void * getPixmap(Bulkhead *crea, bool big);
  void * getPixmap(Flame *crea, bool big);
  void * getPixmap(EntryZone *crea, bool big);
  void * getPixmap(ModuleCAT *crea, bool big);
  void * getPixmap(Exit *crea, bool big);
  void * getPixmap(ExtensibleObject *ext, bool b);


  void Message(QString msg);

private:
  QString _getStringPosition(Object *obj);
  QString _getStringOverwatch(BolterMarine *crea);

  QInterfaceImpl *main;
  QThemeEngine *theme;
};

#endif
