#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qlabel.h>
#include <qcheckbox.h>

#include "qmaildialogimpl.h"

#include "guicommandline.h"

/* 
 *  Constructs a QMailDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
QMailDialogImpl::QMailDialogImpl( QWidget* parent, SmtpInfo *i )
  : mail_dialog( parent, "Get infos for sending email", true ), info(i) 
{
  smtp->setText(info->smtp);
  email->setText(info->yourEmail);
  opponent_email->setText(info->opponentEmail);
  smtp_port->setText(info->port);
  useAuth->setChecked(info->useAuth);
  login->setText(info->login);
  password->setText(info->password);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
QMailDialogImpl::~QMailDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void QMailDialogImpl::click_ok()
{
  info->smtp = smtp->text();
  info->yourEmail = email->text();
  info->opponentEmail = opponent_email->text();
  info->playermsg = msg->text();
  info->port = smtp_port->text();
  info->useAuth = useAuth->isChecked();
  info->login = login->text();
  info->password = password->text();
  done(0);
}

void QMailDialogImpl::authentification(bool enabled)
{
  loginLabel->setEnabled(enabled);
  login->setEnabled(enabled);
  passwordLabel->setEnabled(enabled);
  password->setEnabled(enabled);
}
