#include "qmyevent.h"

/* Type must be :
1000 : to write on the qinfo panel.
1001 : to write on the qlist panel
1002 : to write on the qview panel
1003 : to write on the qselected panel. */
WriteCustomEvent::WriteCustomEvent(int type, QString m)
  : QCustomEvent(type), msg(m)
{}

WriteCustomEvent::~WriteCustomEvent() {}

QString WriteCustomEvent::getMsg(void) { return msg; }

ResizeCustomEvent::ResizeCustomEvent(int xx, int yy)
: QCustomEvent(1010), x(xx), y(yy)
{}

ResizeCustomEvent::~ResizeCustomEvent() {}

int ResizeCustomEvent::getX(void) { return x; }
int ResizeCustomEvent::getY(void) { return y; }
	

ButtonShowHideCustomEvent::ButtonShowHideCustomEvent(bool v)
: QCustomEvent(1011), visible(v)
{}

ButtonShowHideCustomEvent::~ButtonShowHideCustomEvent() {}

bool ButtonShowHideCustomEvent::getStatus(void) { return visible; }


DrawInterfaceCustomEvent::DrawInterfaceCustomEvent(int a)
: QCustomEvent(1020), type(a) {}

DrawInterfaceCustomEvent::~DrawInterfaceCustomEvent() {}

bool DrawInterfaceCustomEvent::mustDrawAll(void) { return type==0; }
bool DrawInterfaceCustomEvent::mustClearCreatureList(void) { return type==1; }
bool DrawInterfaceCustomEvent::mustClearInfoPanel(void) { return type==2; }


CenterCustomEvent::CenterCustomEvent(int c)
  : QCustomEvent(1025), caseId(c) {}
CenterCustomEvent::~CenterCustomEvent() {}
int CenterCustomEvent::centerCaseId(void) { return caseId; }
