/***************************************************************************
                          qthemeengine.h  -  description
                             -------------------
    begin                : sam oct 16 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _QTHEMEENGINE_H_
#define _QTHEMEENGINE_H_

#include <qdir.h>
#include <qpixmap.h>
#include <qcolor.h>

#include <set>
#include <vector>
#include <map>

using namespace std;

#include "variables.h"

class QThemeEngine {
  friend class QDataStoring;
public:
  QThemeEngine(void);
  ~QThemeEngine(void);

  void removeAll(void);

  QString getCurrentTheme(void);
  
  void setTheme(QString theme);
  set<QString>* getAllThemes(void);
  void setRandomGround(bool visible);
  void setDeadTile(int caseId, bool isMarine);
  bool isIsometric(void);

  QPixmap* getCase(bool big, int caseId);
  QPixmap* getBlip(bool big);
  QPixmap* getFlame(bool big);
  QPixmap* getEntryZone(bool big, Direction dir); 
  QPixmap* getExit(bool big, Direction dir);
  QPixmap* getModuleCAT(bool big);
  QPixmap* getDoor(bool big, DoorState state, bool vertical);
  QPixmap* getBulkhead(bool big, DoorState state, bool vertical);
  QPixmap* getMarine(bool big, Direction dir);
  QPixmap* getFlamer(bool big, Direction dir);
  QPixmap* getSergeant(bool big, Direction dir);
  QPixmap* getGenestealer(bool big, Direction dir);
  QPixmap* getExtensible(bool big, QString &graphic);

  QColor* getBgColor(void);
  QColor* getFontColor(void);
private:
  set<QString> themes;
  QString current;
  
  bool orientedExit, orientedEntry;
  bool visibleRandomGround;
  bool useDeadTiles;
  bool isometric;

  QPixmap pixblip_42, pixblip_21, pixdoorclose_v_42, pixdoorclose_h_42,
    pixdoorclose_v_21, pixdoorclose_h_21, pixdooropen_v_42, pixdooropen_h_42,
    pixdooropen_v_21, pixdooropen_h_21, pixbulkopen_h_42, pixbulkclose_h_42,
    pixbulkopen_h_21, pixbulkclose_h_21, pixbulkopen_v_42, pixbulkclose_v_42,
    pixbulkopen_v_21, pixbulkclose_v_21, pixflame_42, pixflame_21,
    pixentryzone_42_n , pixentryzone_21_n,
    pixentryzone_42_s, pixentryzone_21_s , pixentryzone_42_e,
    pixentryzone_21_e, pixentryzone_42_w , pixentryzone_21_w,
    pixexit_42_n , pixexit_21_n, pixexit_42_s, pixexit_21_s, 
    pixexit_42_e, pixexit_21_e, pixexit_42_w , pixexit_21_w,
    pixcat_42, pixcat_21, pixtoxinduct_42, pixtoxinduct_21,
    pixarchives_42, pixarchives_21, pixmachinery_42, pixmachinery_21,
    pixflamer_42_n, pixflamer_21_n, pixflamer_42_s, pixflamer_21_s,
    pixflamer_42_e, pixflamer_21_e, pixflamer_42_w, pixflamer_21_w,
    pixgenestealer_42_n, pixgenestealer_21_n, pixgenestealer_42_s,
    pixgenestealer_21_s, pixgenestealer_42_e, pixgenestealer_21_e,
    pixgenestealer_42_w, pixgenestealer_21_w, pixmarine_42_n, 
    pixmarine_21_n, pixmarine_42_s, pixmarine_21_s, pixmarine_42_e, 
    pixmarine_21_e, pixmarine_42_w, pixmarine_21_w, 
    pixsergeant_42_n, pixsergeant_21_n, pixsergeant_42_s, pixsergeant_21_s,
    pixsergeant_42_w, pixsergeant_21_w, pixsergeant_42_e, pixsergeant_21_e,
    pixcase_42, pixcase_21;
  vector<QPixmap *> additionalGrounds_42;
  vector<QPixmap *> additionalGrounds_21;
  QPixmap pixdeadmarine_42, pixdeadmarine_21, pixdeadgen_42, pixdeadgen_21;
  map<int, int> cases;
  map<int, QPixmap *> grounds_42;
  map<int, QPixmap *> grounds_21;

  QColor bgcolor, fontcolor;
};

#endif
