///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// $Id: FrequencyDBImpl_cache.h,v 1.11 2003/08/30 21:42:24 bburton Exp $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//

#ifndef _FrequencyDBImpl_cache_h
#define _FrequencyDBImpl_cache_h

#include "FrequencyDBImpl.h"

class FrequencyDBImpl_cache : public FrequencyDBImpl
{
public:
  FrequencyDBImpl_cache(FrequencyDBImpl *db);
  ~FrequencyDBImpl_cache();

  bool open(const string &filename,
            bool read_only,
            int create_mode);
  void close();

  void flush();

  void writeWord(const string &word,
                 const WordData &word_data);

  bool readWord(const string &word,
                WordData &word_data);

  bool firstWord(string &word,
                 WordData &counts);

  bool nextWord(string &word,
                WordData &counts);

  string getDatabaseType() const;

  void sweepOutOldTerms(int junk_count,
			int max_age);

private:
  /// Not implemented.
  FrequencyDBImpl_cache(const FrequencyDBImpl_cache &);

  /// Not implemented.
  FrequencyDBImpl_cache& operator=(const FrequencyDBImpl_cache &);

private:
  struct CacheEntry
  {
    CacheEntry(bool _is_dirty,
	       bool _is_shared,
               WordData *_counts)
      : is_dirty(_is_dirty),
        counts(_counts)
    {
    }

    bool is_dirty;
    bool is_shared;
    WordData *counts;
  };

  typedef map<string,CacheEntry>::iterator map_iter_t;
  typedef map<string,CacheEntry>::const_iterator map_const_iter_t;

  NewPtr<FrequencyDBImpl> m_db;
  map<string,CacheEntry> m_cache;
};

#endif // _FrequencyDBImpl_cache_h
