///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// $Id: export0_6.cc,v 1.3 2003/08/30 21:42:24 bburton Exp $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//

#ifndef USE_DBM
#error export0_6 only works with GDBM
#endif

extern "C" {
#include <ndbm.h>
#include <unistd.h>
#include <fcntl.h>
}
#include <stdexcept>
#include <iostream>
#include "LockFile.h"

static void export_dbm(const string &filename,
                       bool is_spam,
                       ostream &out)
{
  DBM *db = dbm_open(filename.c_str(), O_RDWR, 0600);
  if (db == NULL) {
    cerr << "error: unable to open file " << filename.c_str() << endl;
    exit(1);
  }

  datum key = dbm_firstkey(db);
  while (key.dptr != NULL) {
    datum value = dbm_fetch(db, key);
    if (value.dptr != NULL) {
      if (is_spam) {
        out << "0," << *(int *)value.dptr << ",\"" << key.dptr << "\"" << endl;
      } else {
        out << *(int *)value.dptr << ",0,\"" << key.dptr << "\"" << endl;
      }
    }
    key = dbm_nextkey(db);
  }

  dbm_close(db);
}

int main(int argc,
         char **argv)
{
  try {
    File basedir(File::getHomeDir(), ".spamprobe");

    int opt;
    bool usage_error = false;
    optind = 1;
    while ((opt = getopt(argc, argv, "d:")) != EOF) {
      switch (opt) {
      case 'd':
        basedir.setPath(optarg);
        break;

      default:
        usage_error = true;
        break;
      }
    }

    if (usage_error || optind != argc) {
      cerr << "usage: export0_6 [-d dirname]" << endl;
      return 1;
    }

    export_dbm(File(basedir, "goodwords").getPath(), false, cout);
    export_dbm(File(basedir, "spamwords").getPath(), true, cout);
    return 0;

  } catch (runtime_error &ex) {
    cerr << "caught runtime exception: " << ex.what() << endl;
    return 1;
  } catch (logic_error &ex) {
    cerr << "caught logic exception: " << ex.what() << endl;
    return 1;
  } catch (...) {
    cerr << "caught unknown exception" << endl;
    return 1;
  }
}
