/* $Header: /home/agc/src/ssam-1.9/RCS/main.c,v 1.9 1997/10/21 10:06:16 agc Exp agc $ */

/*
 * Copyright © 1996-1997 Alistair G. Crooks.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Alistair G. Crooks.
 * 4. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <config.h>

#include <stdio.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "agc.h"
#include "ssam.h"

/* get the command string, possibly from a file */
static char *
getcommand(char *f, char **argv)
{
	struct stat	s;
	FILE		*fp;
	char		*command;
	int		cc;

	if (f == (char *) NULL) {
		return  *argv;
	}
	if ((fp = fopen(f, "r")) == (FILE *) NULL) {
		(void) fprintf(stderr, "Can't open command file `%s'\n", f);
		return (char *) NULL;
	}
	(void) fstat(fileno(fp), &s);
	NEWARRAY(char, command, s.st_size + 1, exit(1));
	cc = fread(command, sizeof(char), s.st_size, fp);
	(void) fclose(fp);
	if (cc != s.st_size) {
		(void) fprintf(stderr, "Bad read of command file `%s'\n", f);
		return (char *) NULL;
	}
	command[cc] = 0;
	return command;
}

/* print usage message and die */
static void
usage(char **argv)
{
	(void) fprintf(stderr, "Usage: %s [-a collseq] [-b] [-f filename] [-n] [-v] [-w] [-x] [files...]\n", *argv);
	exit(1);
}

extern int	optind;
extern char	*optarg;

/* main routine - calls all the ssam stuff */
int
main(int argc, char **argv)
{
	ssam_t	sam;
	char	*command;
	char	*f;
	char	*collseq;
	int	flags;
	int	i;

	(void) memset(&sam, 0, sizeof(sam));
	command = f = (char *) NULL;
	flags = 0;
	collseq = getenv("UTFCOLLSEQ");
	while ((i = getopt(argc, argv, "a:bf:nvwx")) != -1) {
		switch(i) {
		case 'a':
			collseq = optarg;
			break;
		case 'b':
			flags |= ByteOffsets;
			break;
		case 'f':
			f = optarg;
			break;
		case 'n':
			flags |= NoEcho;
			break;
		case 'v':
			printf("ssam %s %s\n", SSAM_VERSION_STRING, __DATE__);
			printf("Mail bug-reports to %s\n", SSAM_AUTHOR_STRING);
			exit(0);
		case 'w':
			flags |= Writeable;
			break;
		case 'x':
			flags |= Explain;
			break;
		default:
			usage(argv);
		}
	}
	if ((command = getcommand(f, &argv[optind])) == (char *) NULL) {
		exit(1);
	}
	argc -= optind + 1;
	argv += optind + 1;
	if (!ssamfiles(&sam, argc, argv)) {
		exit(1);
	}
	if (!ssam(&sam, command, argc, flags, collseq)) {
		exit(1);
	}
	if (!ssamcommit(&sam, argc, flags)) {
		exit(1);
	}
	ssamfree(&sam, (FreeCommands | FreeChanges | CloseFiles | FreeFiles | FreeMatches));
	if (f != (char *) NULL) {
		FREE(command);
	}
	exit(0);
}
