.TH SU2 8
.SH NAME
su2 \- become another user
.SH SYNOPSIS
.B su2
[
.B \-u
fromname ] [
.B \-x
] [
.B \-s
] [
.B \-r
] [
.B \-d
] [
.B \-h
] [
.I \-niceval
] [ toname ] [
.B \-c
file ]
.SH DESCRIPTION
.I su2\^
allows one to become another user
(usually root) without logging off or knowing the users password.
The
.I toname
specifies the user to switch to.
The default is the root user.
.LP
To use
.IR su2 ,
the
.IR fromuser 's
name
must be listed in either the file
.B /etc/super-users
or in the file
.B .su2rc
in the home directory of
.IR touser .
The
.B .su2rc
file must be owned by
.IR touser ,
and the file's setuid bit must be set.
Finally,
.IR fromuser 's
valid password must be specified.
If the above conditions are met,
.I su2\^
will execute a new shell (as specified by the
.B $SHELL
environment variable) with the user \s-1ID\s0 set to
that of
.IR touser .
If
.B $SHELL
is not defined,
.B /bin/sh
will be executed.
To restore normal user \s-1ID\s0 privileges,
type an
.SM
.B EOF
to the new shell.
.LP
.I Su2
unlike
.I su
will not modify
.BR $PATH ,
unless the
.I -
option is specified.  The only exception is any unanchored
paths (those that do not begin with a "/") will be removed
when changing to super-user.
.I Su2\^
will also ensure that the super-user gets a "#" prompt to remind him
of his additional responsibilities and removes the "#" prompt when switching
from super-user.
.LP
.I Su2\^
logs all attempts to
.I su2\^
in /usr/adm/sulog, including failures.  Successful attempts are flagged
with "+", failures with "-".
.LP
The file
.B /etc/super-users
contains a list of users, one to a line, that are authorized to
.I su2
to any user.  Each user's
.B .su2rc
file contains a similar list of users who may
.I su2
to that user.
A username may be prefixed by a "\fB+\fR" to bypass password
checking when logged on as that user.
A password will always be required if the
.B -u
option is specified.
Care must be taken to insure that
.B /etc/super-users
is writable only by root in order to
prevent users from being able to add names to the list.
.SH OPTIONS
.TP
.B \-u
is used to specify a user against whom to check authorization and password.
The default value is obtained from
.I /etc/utmp.
.TP
.B \-x
when specified will cause
.I "su2"
to exec the shell without first forking a new process.  This option should
only be used when the system is out of process slots.  When it is used
su2 will neither clean up the
.I /etc/utmp
entry nor reset the ownership and mode of the current
.IR /dev/tty?? .
Both may be reset with the
.B \-r
option.
.TP
.B \-s
will change the current
.I /etc/utmp
entry to reflect the new user name.
.TP
.B \-r
is used to replace the username in
.I /etc/utmp
and the mode and ownership of
.I /dev/tty??
with that associated with the current process userid.
.TP
.B \-d
says to run a default shell
.RI ( /bin/csh
for
.B BSD
systems,
.I /bin/sh
for other systems).
.TP
.B \-h
says to leave $HOME alone in case
it would have been changed otherwise.
This is needed if you don't use the
.B "@#$%"
C-hell.
.TP
.B \-c
specifies a file to execute in the same fashion as the
.I \-c
option of
.IR su (1).
.TP
.I \-niceval
is a nice increment in the range -20 to 20.
.I niceval
is subtracted from the current
nice value (similar to the
.IR nice (1)
command).  A negative value increases the effective priority.
.SH FILES
.PD 0
.TP 30m
/etc/passwd
system's password file.
.TP
/etc/super-users
authorized super-users for the system.
.TP
$HOME/.su2rc
list of users authorized to change to a specific user.
.TP
/usr/adm/sulog
log of
.I su2
and
.I su
attempts.
.PD
.PP
.SH SEE ALSO
su(1), env(1), login(1), nice(1), sh(1), environ(7).
.SH BUGS
The behavior of
.I su2
is controlled by scads of compile-time options, so this
document may not be accurate.  The options should be replaced
by flags.
.LP
When run normally
.I su2
will occupy 2 additional process slots
which may pose a problem when trying to
repair a swamped system.
Using the
.I \-x
option eliminates the second process.
.LP
The code is full of explicit constants and pointer ugliness,
and should probably be thrown out and rewritten.
