/*
 * Sylpheed -- a GTK+ based, lightweight, and fast e-mail client
 * Copyright (C) 1999-2004 Hiroyuki Yamamoto
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __FILTER_H__
#define __FILTER_H__

#include <glib.h>

#include "folder.h"

typedef struct _FilterCond	FilterCond;
typedef struct _FilterAction	FilterAction;
typedef struct _FilterRule	FilterRule;

typedef enum
{
	FLT_COND_HEADER,
	FLT_COND_ALL_HEADER,
	FLT_COND_TO_OR_CC,
	FLT_COND_BODY,
	FLT_COND_CMD_TEST,
	FLT_COND_SIZE_GREATER,
	FLT_COND_SIZE_LESS_OR_EQ,
	FLT_COND_AGE_GREATER,
	FLT_COND_AGE_LESS_OR_EQ,
} FilterCondType;

typedef enum
{
	FLT_CONTAIN,
	FLT_EQUAL,
	FLT_REGEX
} FilterMatchType;

typedef enum
{
	FLT_NOT_MATCH	= 1 << 0,
	FLT_CASE_SENS	= 1 << 1
} FilterMatchFlag;

typedef enum
{
	FLT_AND,
	FLT_OR
} FilterBoolOp;

typedef enum
{
	FLT_ACTION_MOVE,
	FLT_ACTION_COPY,
	FLT_ACTION_NOT_RECEIVE,
	FLT_ACTION_DELETE,
	FLT_ACTION_EXEC,
	FLT_ACTION_EXEC_ASYNC,
	FLT_ACTION_MARK,
	FLT_ACTION_COLOR_LABEL,
	FLT_ACTION_MARK_READ,
	FLT_ACTION_FORWARD,
	FLT_ACTION_FORWARD_AS_ATTACHMENT,
	FLT_ACTION_REDIRECT
} FilterActionType;

#define FLT_IS_NOT_MATCH(flag)	((flag & FLT_NOT_MATCH) != 0)
#define FLT_IS_CASE_SENS(flag)	((flag & FLT_CASE_SENS) != 0)

struct _FilterCond
{
	FilterCondType type;

	gchar *header;
	gchar *body;
	FilterMatchType match_type;
	FilterMatchFlag match_flag;
	gboolean (*match_func) (const gchar *haystack, const gchar *needle);
};

struct _FilterAction
{
	FilterActionType type;
	gchar *dest_folder;
};

struct _FilterRule
{
	gchar *name;

	GSList *cond_list;
	FilterBoolOp bool_op;

	GSList *action_list;
};

#define FILTER_NOT_RECEIVE	"//NOT_RECEIVE//"

FolderItem *filter_get_dest_folder	(GSList			*fltlist,
					 const gchar		*file);
gboolean filter_match_rule		(FilterRule		*rule,
					 GSList			*hlist);
gchar *filter_get_str			(FilterRule		*rule);
FilterRule *filter_read_str		(const gchar		*str);
FilterCond *filter_cond_new		(const gchar		*header,
					 const gchar		*body,
					 FilterMatchType	 type,
					 FilterMatchFlag	 flag);
gboolean filter_rule_is_equal		(FilterRule		*rule1,
					 FilterRule		*rule2);
void filter_rule_rename_dest_path	(FilterRule		*rule,
					 const gchar		*old_path,
					 const gchar		*new_path);
gboolean filter_rule_match_dest_path	(FilterRule		*rule,
					 const gchar		*path);
FilterAction *filter_rule_get_last_action
					(FilterRule		*rule);

void filter_rule_free			(FilterRule		*rule);

#endif /* __FILTER_H__ */
