Summary: Synonym - The Message Archiver
Name: synonym
URL: http://www.modulo.ro/synonym
Version: 0.4
Release: 3
License: Modulo Consulting Software License 1.0 (Apache/BSD style)
Group: Networking/Mail
Source: http://www.modulo.ro/synonym/source/synonym-%{version}-%{release}.tar.gz
Distribution: RedHat Linux
Vendor: Modulo Consulting
Packager: Ionut Nistor <ionut@modulo.ro>
Requires: sendmail >= 8.9.3
Prefix: /
BuildRoot: /%_tmppath/%name-%version-%release-buildroot/
%description 
Synonym is a Milter extension running on top of Sendmail that allows a company to easily archive all email messages going in and out. It can copy mail messages, delete, reject or add a text and/or html signature based on a XML based configuration file listing regular expression rules. 

You should install Synonym if you are already running a Sendmail server and wish to copy
the mail messages flowing through that server to a mailbox.
%prep
rm -rf "$RPM_BUILD_ROOT"
%setup
%build
make
%install
make SYNONYM_BASEDIR="$RPM_BUILD_ROOT" install_rpm
%clean 
rm -rf $RPM_BUILD_ROOT

%files
%attr (-,mail,mail) %dir /var/run/synonym
%attr (-,root,root) %dir /usr/local/sbin/
%attr (-,root,root) /usr/local/sbin/synonym
%attr (-,root,root) %config /etc/rc.d/init.d/synonym
%attr (-,root,root) %config /etc/synonym.conf
%attr (-,root,root) %dir /usr/share/doc/synonym
%attr (-,root,root) %doc /usr/share/doc/synonym/README
%attr (-,root,root) %doc /usr/share/doc/synonym/license.txt

%pre
if [ "$1" = 1 ]; then
	echo "Installing Synonym"
else
	echo "Upgrading Synonym"
	service synonym stop
fi
echo "Copying files..."
%post
if [ "$1" = 1 ]; then
	echo "Install completed"
else
	#we're upgrading
	service synonym start
	echo "Upgrade completed"
fi
%preun
if [ "$1" = 0 ]; then
	echo "Uninstalling Synonym"
	if ! service synonym stop; then
		echo "Synonym was not running"
	fi
	rm -f /var/run/synonym/synonym.pid /var/run/synonym/synonym.sock
fi
%postun
if [ "$1" = 0 ]; then
	echo "Uninstall completed"
fi
