/*
 * Program: Synonym
 * File: body_parser.c
 * Author: Cristian Draghici
 * Date: 11 Nov 2003
 *
 * $Id: body_parser.h,v 1.2 2004/01/19 09:24:31 diciu Exp $
 *
 * Licensed under the Modulo Consulting Software License
 * (see file license.txt)
 * 
 */
#ifndef _BODY_PARSER_H_INCLUDED
#define _BODY_PARSER_H_INCLUDED

#include "c-client/mail.h"
#include "c-client/osdep.h"
#include "c-client/rfc822.h"
#include "c-client/flstring.h"

#include "disclaimer.h"

#define BODY_PARSER_SUCCESS	0
#define BODY_PARSER_FAILURE	1

typedef struct _tag_attachment_handling_rule {
	char *src;
	char *dst;
	struct _tag_attachment_handling_rule *next;
} attachment_handling_rule;

typedef struct {
 	ENVELOPE *envelope;
 	BODY *body;
 	
 	short text_processed;
 	short html_processed;
 	
 	FILE *in_stream;
	FILE *out_stream;
 	
 	disclaimer_state *d_state;
 	attachment_handling_rule *attachment_rule;
 	int body_flag;
} body_parser_state;



int body_parser_init(char *header_content, FILE *body_stream, long body_size, body_parser_state *current_state);
int body_parser_finalize(body_parser_state *current_state);
void process_attachment_names(attachment_handling_rule * att_rule);


#endif
