/*
 * Program: Synonym
 * File: config.h
 * Author: Cristian Draghici
 * Date: 11 Sep 2003
 *
 * $Id: disclaimer.h,v 1.3 2004/01/19 09:24:31 diciu Exp $
 *
 * Licensed under the Modulo Consulting Software License
 * (see file license.txt)
 * 
 */
#ifndef _DISCLAIMER_H_INCLUDED
#define _DISCLAIMER_H_INCLUDED

#define DISCLAIMER_SUCCESS	1
#define DISCLAIMER_FAILURE	0

/* possible part types: 
	SUBTYPE_PLAIN adds signature to text/plain,
	SUBTYPE_HTML adds signature to text/html,
	SUBTYPE_BOTH adds signature to both text/plain and text/html */
#define SUBTYPE_NONE           -1
#define SUBTYPE_PLAIN		1
#define SUBTYPE_HTML		2
#define SUBTYPE_BOTH		3

/* disclaimer structure - helps retain state in a MT safe way */
typedef struct {
	/* filled by others, tells the disclaimer which signature to add (html,text or both) */
	short operation_mode;
	/* filled by others, body of the text signature 
	MUST be allocated, \0 terminated! string */
	char *disclaimer_text;
	/* filled by others, body of the html signature 
	MUST be allocated, \0 terminated! string */
	char *disclaimer_html;
	
	/*used to limit processing to one part */
	short disclaimer_text_processed;
	short disclaimer_html_processed;

} disclaimer_state;

int disclaimer_init(disclaimer_state *current_state);
char * add_text_disclaimer(char *content, long size, long *processed_size, disclaimer_state *current_state);
char * add_html_disclaimer(char *content, long size, long *processed_size, disclaimer_state *current_state);
int linecolumn_to_byte(char *content, int size, int lin, int col);

#endif
