/*
 * Program: Synonym
 * File: milter_data.h
 * Author: Ionut Nistor
 * Date: 11 Sep 2003
 *
 * $Id: milter_data.h,v 1.4 2004/01/19 09:24:31 diciu Exp $
 *
 * Licensed under the Modulo Consulting Software License
 * (see file license.txt)
 * 
 */

#ifndef _MILTER_DATA_INCLUDED
#define _MILTER_DATA_INCLUDED


#include "config.h"

#ifdef DISCLAIMER_SUPPORT
	#include "body_parser.h"
#endif


/* 
 * Structures
 */

#define MAX_HEADER_NAME_SIZE 256
#define MAX_HEADER_VALUE_SIZE 1024
/* Headers - will be filled-up while the headers are being sent from sendmail */
typedef struct _tag_synonym_header {
	char header_name[MAX_HEADER_NAME_SIZE+1];
	char header_value[MAX_HEADER_VALUE_SIZE+1];
	struct _tag_synonym_header *next;
} synonym_header;

#define MAX_EMAIL 512
typedef struct _tag_to_list {
	char email[MAX_EMAIL+1];
	struct _tag_to_list *next;
} to_list;

/* Per instance state variables (mail session dependent - i.e. ENV FROM, headers a.s.o.) */
typedef struct {
	int none;
	synonym_header *headers;
	matched_action *resulted_actions;
	BOOL error_encountered; /* Used to notify subsequent processing functions that a critical error occured and no further processing should be performed */

#ifdef DISCLAIMER_SUPPORT	
	/* disclaimer fields*/
	FILE *output_stream;
	char temp_filename[256]; /* Shouldn't be this big - we only use /tmp/synonymXXXXXX but let's be sure - maybe someone will change it */
	body_parser_state *bp_state;
#endif
	char env_from[MAX_EMAIL+1];
	to_list *env_to;
} synonym_priv;

#endif
