#!/bin/sh

# Synonym startup script for FreeBSD

SYNONYM_PID=/var/run/synonym/synonym.pid

RETVAL=0

ECHO=echo

if [ -f /usr/ucb/echo ]
	then ECHO=/usr/ucb/echo
fi

# Function used to start the synonym daemon
start() {
 	$ECHO -n "Starting synonym: "
	if [ -f /var/run/synonym/synonym.pid ]
		then 	if kill -0 `cat /var/run/synonym/synonym.pid`
				then $ECHO "Already running"; return
				else $ECHO "PID found but synonym stopped. "
			fi
	fi
			
	if /usr/local/sbin/synonym -d -u daemon
		then $ECHO "Success"
		else $ECHO "Failed"
	fi
}	
# Function used to stop the synonym daemon
stop() {
	$ECHO -n "Shutting down synonym: "
	if [ -f /var/run/synonym/synonym.pid ] 
		then 	if kill `cat /var/run/synonym/synonym.pid` 
				then $ECHO -n ""
				else $ECHO "Failed"; return
			fi
		else $ECHO "Not running"; return
	fi
	COUNT=0
	while test $COUNT -lt 7
	do 	if [ -f /var/run/synonym/synonym.pid ]
			then COUNT=`expr $COUNT + 1`; sleep 1
			else break
		fi
	done
	if test $COUNT -eq 7
		then $ECHO "Synoym failed to stop in a timely fashion"
		else $ECHO "Success"
	fi
}

# Function used to restart the synonym daemon
restart() {
	stop
	start
}	


status() {
	if [ -f /var/run/synonym/synonym.pid ]
		then    if kill -0 `cat /var/run/synonym/synonym.pid`
				then $ECHO "Synonym running"
				else $ECHO -n "PID found but Synonym stopped"
			fi
	else $ECHO "Synonym stopped"
	fi
	
}
case "$1" in
  start)
  	start
	;;
  stop)
  	stop
	;;
  status)
	status
	;;
  restart|reload)
  	restart
	;;
  *)
	$ECHO "Usage: $0 {start|stop|status|restart}"
	exit 1
esac

