/*
 * Program: Synonym
 * File: synonym.h
 * Author: Ionut Nistor
 * Date: 20 Feb 2003
 *
 * $Id: synonym.h,v 1.4.2.3 2004/10/20 12:30:12 ionut Exp $
 *
 * Licensed under the Modulo Consulting Software License
 * (see file license.txt)
 * 
 */
#ifndef _SYNONYM_H_INCLUDED
#define _SYNONYM_H_INCLUDED

#define SYNONYM_VERSION "0.4-3"

/*
 *  General definitions 
 */

#ifndef BOOL
#define BOOL unsigned short
//typedef unsigned short bool;
#endif

#ifndef FALSE
# define FALSE	0
#endif /* ! FALSE*/
#ifndef TRUE
# define TRUE	1
#endif /* ! TRUE*/

/* 
 * Result code returned by various Synonym functions - type definition
 */
typedef unsigned int sresult;

/*
 * Result codes
 */
/* Global - most functions make use of them */
#define SYNONYM_OK 0
#define SYNONYM_ALLOC_FAILED 1


/* the following for use by Synonym_Get_Config */
#define SYNONYM_FAILED_LOAD_CONFIG 11
#define SYNONYM_CONFIG_ERROR 12
#define SYNONYM_CONFIG_INTERNAL_ERROR 13

/* the following used by Synonym_Process_Rules */
#define SYNONYM_RULES_PROCESSING_ERROR 30


/*
 * Defaults
 */
#define PIDFILE "/var/run/synonym/synonym.pid"
#define DEFAULT_SOCKET "local:/var/run/synonym/synonym.sock"
#define DEFAULT_CONFIG "/etc/synonym.conf"
#define DEFAULT_USER "mail"
#define DEFAULT_LOGLEVEL LOG_ERR
#define DEFAULT_LOGFACILITY LOG_MAIL
#define DEFAULT_LOGLEVEL_STRING "LOG_ERR"
#define DEFAULT_LOGFACILITY_STRING "LOG_MAIL"


/* 
 * Strings
 */
#define SYNONYM_COPIEDBY "Copied by Synonym (http://www.modulo.ro/synonym) to: "
#define SYNONYM_DISCLAIMERBY "Disclaimer by Synonym (http://www.modulo.ro/synonym)"

#endif
