# makerss.rb Japanese resources
begin
	require 'uconv'
	@makerss_encode = 'UTF-8'
	@makerss_encoder = Proc::new {|s| Uconv.euctou8( s ) }
rescue LoadError
	@makerss_encode = @conf.encoding
	@makerss_encoder = Proc::new {|s| s }
end

def makerss_tsukkomi_label( id )
	"#{id[0,4]}-#{id[4,2]}-#{id[6,2]}Υĥå[#{id[/[1-9]\d*$/]}]"
end

@makerss_conf_label = 'RSS'

def makerss_conf_html
	<<-HTML
	<h3>RSS</h3>
	<p>RSS¾Υץɤߤ䤹ǡƤޤRSS˴ޤޤRSS꡼ɤޤ줿ꡢΥȤžܤ줿ꤷѤƤޤ</p>
	<ul>
	<li>RSS<select name="makerss.hidecomment">
		<option value="f"#{@conf['makerss.hidecomment'] ? '' : ' selected'}>ĥåߤΤޤ</option>
		<option value="text"#{@conf['makerss.hidecomment'] == 'text' ? ' selected' : ''}>ĥåߤդƼԤޤ</option>
		<option value="any"#{@conf['makerss.hidecomment'] == 'any' ? ' selected' : ''}>ĥåߤޤʤ</option></select>
	<li>RSSʸΤ<select name="makerss.hidecontent">
		<option value="f"#{@conf['makerss.hidecontent'] ? '' : ' selected'}>ޤ</option>
		<option value="t"#{@conf['makerss.hidecontent'] ? ' selected' : ''}>ޤʤ</option></select>
	<li>RSS˴ޤ<select name="makerss.shortdesc">
		<option value="f"#{@conf['makerss.shortdesc'] ? '' : ' selected'}>ǤĹ</option>
		<option value="t"#{@conf['makerss.shortdesc'] ? ' selected' : ''}>ǽˤ</option></select>
      <li>#{ comment_new }פȤ󥯤<select name="makerss.comment_link">
		<option value="f"#{@conf['makerss.comment_link'] ? '' : ' selected'}></option>
		<option value="t"#{@conf['makerss.comment_link'] ? ' selected' : ''}>ʤ</option></select>
	</ul>
   HTML
end

@makerss_edit_label = 'äȤ(RSS򹹿ʤ)'
