#
# ja/00default.rb: Japanese resources of 00default.rb.
#
# Copyright (C) 2001-2005, TADA Tadashi <sho@spc.gr.jp>
# You can redistribute it and/or modify it under GPL2.
#

#
# header
#
def title_tag
	r = "<title>#{CGI::escapeHTML( @html_title )}"
	case @mode
	when 'day', 'comment'
		r << "(#{@date.strftime( '%Y-%m-%d' )})" if @date
	when 'month'
		r << "(#{@date.strftime( '%Y-%m' )})" if @date
	when 'form'
		r << '(ɵ)'
	when 'edit'
		r << '(Խ)'
	when 'preview'
		r << '(ץӥ塼)'
	when 'showcomment'
		r << '(ѹλ)'
	when 'conf'
		r << '()'
	when 'saveconf'
		r << '(괰λ)'
	when 'nyear'
		years = @diaries.keys.map {|ymd| ymd.sub(/^\d{4}/, "")}
		r << "(#{@cgi.params['date'][0].sub( /^(\d\d)/, '\1-')}[#{nyear_diary_label @date, years}])" if @date
	end
	r << '</title>'
end

#
# TSUKKOMI mail
#
def comment_mail_mime( str )
	require 'nkf'
	NKF::nkf( "-j -m0 -f50", str ).collect do |s|
		%Q|=?ISO-2022-JP?B?#{[s.chomp].pack( 'm' ).gsub( /\n/, '' )}?=|
	end
end

def comment_mail_conf_label; 'ĥåߥ᡼'; end

def comment_mail_basic_html
	@conf['comment_mail.header'] = '' unless @conf['comment_mail.header']
	@conf['comment_mail.receivers'] = '' unless @conf['comment_mail.receivers']
	@conf['comment_mail.sendhidden'] = false unless @conf['comment_mail.sendhidden']

	<<-HTML
	<h3 class="subtitle">ĥåߥ᡼</h3>
	#{"<p>ĥåߤäˡ᡼뤫ɤ򤷤ޤ</p>" unless @conf.mobile_agent?}
	<p><select name="comment_mail.enable">
		<option value="true"#{if @conf['comment_mail.enable'] then " selected" end}></option>
        <option value="false"#{if not @conf['comment_mail.enable'] then " selected" end}>ʤ</option>
	</select></p>
	<h3 class="subtitle"></h3>
	#{"<p>᡼ꤷޤ1Ԥ1᡼륢ɥ쥹ηǡʣǽǤΤʤˤϡʤΥ᡼륢ɥ쥹ޤ</p>" unless @conf.mobile_agent?}
	<p><textarea name="comment_mail.receivers" cols="40" rows="3">#{CGI::escapeHTML( @conf['comment_mail.receivers'].gsub( /[, ]+/, "\n") )}</textarea></p>
	<h3 class="subtitle">᡼إå</h3>
	#{"<p>᡼SubjectˤĤإåʸꤷޤʬʤ褦˻ꤷޤºݤSubjectˤϡֻʸ:-1פΤ褦ˡդȥֹ椬դޤʸˡ%³ѻä硢եեޥåȻ򸫤ʤޤĤޤաפʬϼưŪղäʤʤޤ(ֹղäޤ)</p>" unless @conf.mobile_agent?}
	<p><input name="comment_mail.header" value="#{CGI::escapeHTML( @conf['comment_mail.header'])}"></p>
	<h3 class="subtitle">ɽĥåߤΰ</h3>
	#{"<p>ե륿η̡ǽ餫ɽˤ줿ĥåߤϿ뤳ȤޤɽΥĥåߤ褿Ȥˤ᡼ȯ뤫ɤ򤷤ޤ</p>" unless @conf.mobile_agent?}
	<p><input type="checkbox" name="comment_mail.sendhidden" value="true"#{@conf['comment_mail.sendhidden'] ? ' checked': ''}>ɽΥĥåߤǤ᡼</p>
	HTML
end

#
# link to HOWTO write diary
#
def style_howto
	%Q|/<a href="http://docs.tdiary.org/ja/?#{@conf.style}%A5%B9%A5%BF%A5%A4%A5%EB"></a>|
end

#
# labels (normal)
#
def no_diary; "#{@date.strftime( @conf.date_format )}Ϥޤ"; end
def comment_today; 'Υĥå'; end
def comment_total( total ); "(#{total})"; end
def comment_new; 'ĥåߤ'; end
def comment_description; 'ĥåߡȤФɤ! E-mailɥ쥹ϸޤ'; end
def comment_limit_label; 'ϥĥå߿¤ۤƤޤ'; end
def comment_description_short; 'ĥå!!'; end
def comment_name_label; '̾'; end
def comment_name_label_short; '̾'; end
def comment_mail_label; 'E-mail'; end
def comment_mail_label_short; 'Mail'; end
def comment_body_label; ''; end
def comment_body_label_short; 'ʸ'; end
def comment_submit_label; ''; end
def comment_submit_label_short; ''; end
def comment_date( time ); time.strftime( "(#{@date_format} %H:%M)" ); end
def trackback_today; 'TrackBacks'; end
def trackback_total( total ); "(#{total})"; end

def navi_index; 'ȥå'; end
def navi_latest; 'ǿ'; end
def navi_oldest; 'Ǹ'; end
def navi_update; "ɵ"; end
def navi_edit; "Խ"; end
def navi_preference; ""; end
def navi_prev_diary(date); "(#{date.strftime(@date_format)})"; end
def navi_next_diary(date); "(#{date.strftime(@date_format)})"; end
def navi_prev_month; ""; end
def navi_next_month; ""; end
def navi_prev_nyear(date); "(#{date.strftime('%m-%d')})"; end
def navi_next_nyear(date); "(#{date.strftime('%m-%d')})"; end
def navi_prev_ndays; "#{@conf.latest_limit}ʬ"; end
def navi_next_ndays; "#{@conf.latest_limit}ʬ"; end

def submit_label
	if @mode == 'form' or @cgi.valid?( 'appendpreview' ) then
		'ɵ'
	else
		'Ͽ'
	end
end
def preview_label; 'ץӥ塼'; end

def nyear_diary_label(date, years); "Ĺǯ"; end
def nyear_diary_title(date, years); "Ĺǯ"; end

#
# labels (for mobile)
#
def mobile_navi_latest; 'ǿ'; end
def mobile_navi_update; "ɵ"; end
def mobile_navi_preference; ""; end
def mobile_navi_prev_diary; ""; end
def mobile_navi_next_diary; ""; end
def mobile_label_hidden_diary; 'ϡɽۤǤ'; end

#
# category
#
def category_anchor(c); "[#{c}]"; end

#
# preferences (resources)
#

# genre labels
@conf_genre_label['basic'] = ''
@conf_genre_label['update'] = ''
@conf_genre_label['theme'] = 'ơ'
@conf_genre_label['tsukkomi'] = 'ĥå'
@conf_genre_label['referer'] = '󥯸'
@conf_genre_label['security'] = 'ƥ'
@conf_genre_label['etc'] = '¾'


add_conf_proc( 'default', 'Ȥξ', 'basic' ) do
	saveconf_default
	@conf.description ||= ''
	@conf.icon ||= ''
	@conf.banner ||= ''
	<<-HTML
	<h3 class="subtitle">ȥ</h3>
	#{"<p>HTML&lt;title&gt;椪ӡХüλȻ˻Ȥ륿ȥǤHTMLϻȤޤ</p>" unless @conf.mobile_agent?}
	<p><input name="html_title" value="#{ CGI::escapeHTML @conf.html_title }" size="50"></p>

	<h3 class="subtitle">̾</h3>
	#{"<p>ʤ̾ꤷޤHTMLإåŸޤ</p>" unless @conf.mobile_agent?}
	<p><input name="author_name" value="#{CGI::escapeHTML @conf.author_name}" size="40"></p>

	<h3 class="subtitle">᡼륢ɥ쥹</h3>
	#{"<p>ʤΥ᡼륢ɥ쥹ꤷޤHTMLإåŸޤ</p>" unless @conf.mobile_agent?}
	<p><input name="author_mail" value="#{@conf.author_mail}" size="40"></p>

	<h3 class="subtitle">ȥåץڡURL</h3>
	#{"<p>̤ΥƥĤлꤷޤ¸ߤʤϲϤʤƤޤޤ</p>" unless @conf.mobile_agent?}
	<p><input name="index_page" value="#{@conf.index_page}" size="70"></p>

	<h3 class="subtitle"></h3>
	#{"<p>δñꤷޤHTMLإåŸޤϤʤƤ⤫ޤޤ</p>" unless @conf.mobile_agent?}
	<p><input name="description" value="#{CGI::escapeHTML @conf.description}" size="70"></p>

	<h3 class="subtitle">ȥ(favicon)</h3>
	#{"<p>ɽʥ(favicon)ФURLꤷޤHTMLإåŸޤϤʤƤ⤫ޤޤ</p>" unless @conf.mobile_agent?}
	<p><input name="icon" value="#{CGI::escapeHTML @conf.icon}" size="70"></p>

	<h3 class="subtitle">Хʡ</h3>
	#{"<p>ɽ(Хʡ)ФURLꤷޤmakerssץ饰ʤɤRSSϤʤɤ˻ȤޤϤʤƤ⤫ޤޤ</p>" unless @conf.mobile_agent?}
	<p><input name="banner" value="#{CGI::escapeHTML @conf.banner}" size="70"></p>
	HTML
end

add_conf_proc( 'header', 'إåեå', 'basic' ) do
	saveconf_header

	<<-HTML
	<h3 class="subtitle">إå</h3>
	#{"<p>ƬʸϤꤷޤHTMLȤޤ&lt;%=navi%&gt;פǡʥӥܥǤޤ(줬ʤȹǤʤʤΤǺʤ褦ˤƤ)ޤ&lt;%=calendar%&gt;פǥǤޤ¾Ƽץ饰򵭽ҤǤޤ</p>" unless @conf.mobile_agent?}
	<p><textarea name="header" cols="70" rows="10">#{ CGI::escapeHTML @conf.header }</textarea></p>
	<h3 class="subtitle">եå</h3>
	#{"<p>κǸʸϤꤷޤإåƱͤ˻Ǥޤ</p>" unless @conf.mobile_agent?}
	<p><textarea name="footer" cols="70" rows="10">#{ CGI::escapeHTML @conf.footer }</textarea></p>
	HTML
end

add_conf_proc( 'display', 'ɽ', 'basic' ) do
	saveconf_display

	<<-HTML
	<h3 class="subtitle">󥢥󥫡</h3>
	#{"<p>ΥƬ(֥ȥιƬ)롢ѤΥ󥫡ʸꤷޤʤ&lt;span class=\"sanchor\"&gt;_&lt;/span&gt;פꤹȡơޤˤäƤϼưŪ˲󥫡Ĥ褦ˤʤޤ</p>" unless @conf.mobile_agent?}
	<p><input name="section_anchor" value="#{ CGI::escapeHTML @conf.section_anchor }" size="40"></p>
	<h3 class="subtitle">ĥåߥ󥫡</h3>
	#{"<p>ɼԤΥĥåߤƬ롢ѤΥ󥫡ʸꤷޤʤ&lt;span class=\"canchor\"&gt;_&lt;/span&gt;פꤹȡơޤˤäƤϼưŪ˲󥫡Ĥ褦ˤʤޤ</p>" unless @conf.mobile_agent?}
	<p><input name="comment_anchor" value="#{ CGI::escapeHTML @conf.comment_anchor }" size="40"></p>
	<h3 class="subtitle">եեޥå</h3>
	#{"<p>դɽʬ˻ȤեޥåȤꤷޤǤդʸȤޤ%פǻϤޤѻˤϼΤ褦üʰ̣ޤ%Y(ǯ)%m()%b(û̾)%B(Ĺ̾)%d()%a(û̾)%A(Ĺ̾)</p>" unless @conf.mobile_agent?}
	<p><input name="date_format" value="#{ CGI::escapeHTML @conf.date_format }" size="30"></p>
	<h3 class="subtitle">ǿɽκ</h3>
	#{"<p>ǿɽȤˡΥڡ˲ʬɽ뤫ꤷޤ</p>" unless @conf.mobile_agent?}
	<p><input name="latest_limit" value="#{ @conf.latest_limit }" size="2">ʬ</p>
	<h3 class="subtitle">Ĺǯɽ</h3>
	#{"<p>Ĺǯɽ뤿Υ󥯤ɽ뤫ɤꤷޤ</p>" unless @conf.mobile_agent?}
	<p><select name="show_nyear">
		<option value="true"#{if @conf.show_nyear then " selected" end}>ɽ</option>
        <option value="false"#{if not @conf.show_nyear then " selected" end}>ɽ</option>
	</select></p>
	HTML
end

add_conf_proc( 'timezone', 'Ĵ', 'update' ) do
	saveconf_timezone

	<<-HTML
	<h3 class="subtitle">Ĵ</h3>
	#{"<p>եդñ̤ĴǤޤ㤨и2ޤǤȤưˤϡ-2פΤ褦˻ꤹ뤳Ȥǡ2ʬ줿դ褦ˤʤޤޤդWebоλˤʤäƤΤǡΥФǱĤƤλĴˤѤǤޤ</p>" unless @conf.mobile_agent?}
	<p><input name="hour_offset" value="#{@conf.hour_offset}" size="5"></p>
	HTML
end

@theme_location_comment = "<p>ˤʤơޤ<a href=\"http://www.tdiary.org/20021001.html\">ơޡ꡼</a>Ǥޤ</p>"
@theme_thumbnail_label = "ͥ"

add_conf_proc( 'theme', 'ơ', 'theme' ) do
	saveconf_theme

	r = <<-HTML
	<h3 class="subtitle">ơޤλ</h3>
	#{"<p>Υǥơޡ⤷CSSľϤǻꤷޤɥåץ˥塼CSSꢪפ򤷤ˤϡCSSURLϤƤ</p>" unless @conf.mobile_agent?}
	<p>
	<select name="theme" onChange="changeTheme( theme_thumbnail, this )">
		<option value="">CSSꢪ</option>
	HTML
	r << conf_theme_list
end

add_conf_proc( 'comment', 'ĥå', 'tsukkomi' ) do
	saveconf_comment

	<<-HTML
	<h3 class="subtitle">ĥåߤɽ</h3>
	#{"<p>ɼԤΥĥåߤɽ뤫ɤꤷޤ</p>" unless @conf.mobile_agent?}
	<p><select name="show_comment">
		<option value="true"#{if @conf.show_comment then " selected" end}>ɽ</option>
		<option value="false"#{if not @conf.show_comment then " selected" end}>ɽ</option>
	</select></p>
	<h3 class="subtitle">ĥåߥꥹɽ</h3>
	#{"<p>ǿ⤷Ϸɽɽ롢ĥåߤκꤷޤʤɽˤϤλˤ餺٤ƤΥĥåߤɽޤ</p>" unless @conf.mobile_agent?}
	<p><input name="comment_limit" value="#{ @conf.comment_limit }" size="3"></p>
	<h3 class="subtitle">1Υĥåߺ</h3>
	#{"<p>1˽񤭹ĥåߤκꤷޤοĶȡĥåѤΥեबɽˤʤޤʤTrackBackץ饰ƤˤϡĥåߤTrackBackιפ¤ޤ</p>" unless @conf.mobile_agent?}
	<p><input name="comment_limit_per_day" value="#{ @conf.comment_limit_per_day }" size="3"></p>
	HTML
end

add_conf_proc( 'csrf_protection', 'CSRF(ü)к', 'security' ) do
	err = saveconf_csrf_protection
	errstr = ''
	case err
	when :param
		errstr = '<p class="message">Ȥ߹碌ǤѹޤǤ</p>'
	when :key
		errstr = '<p class="message">ǤѹޤǤ</p>'
	end
	csrf_protection_method = @conf.options['csrf_protection_method'] || 1
	csrf_protection_key = @conf.options['csrf_protection_key'] || ''
	<<-HTML
	#{errstr}
	<p>ȡꥯȥե(CSRF)кˡꤷޤ</p>
	<p>CSRFϡդΤʹ֤Webڡ櫤ųݤޤ
	櫤ųݤڡ򤢤ʤȡʤΥ֥饦
	tDiary˵ν񤭹׵ФƤޤޤʤΥ֥饦
	׵ФƤޤᡢŹ沽ѥݸǤкˤʤޤ
	tDiaryǤϡμιФơRefereråפȡCSRFפȤ
	2ɱҼʤѰդƤޤ</p>
	<div class="section">
	<h3 class="subtitle">Refereråˤɱ</h3>
	<h4>Refererθ</h4>
	<p>#{if [0,1,2,3].include?(csrf_protection_method) then
            '<input type="checkbox" name="check_enabled2" value="true" checked disabled>
            <input type="hidden" name="check_enabled" value="true">'
          else
            '<input type="checkbox" name="check_enabled" value="true">'
        end}(ɸ)</input>
	</p>
	#{"<p>ʤΥ֥饦ФReferer(󥯸)򸡺ޤ
	񤭹׵᤬ڡФ줿Ȥǧ뤳Ȥǡ
	ڡ׵ɤޤʥڡ׵򸡽Ф硢
	ꥯȤݤޤ
	̤Ǥϡ̵ˤ뤳ȤϽޤ</p>
	" unless @conf.mobile_agent?}
	<h4>RefererФʤ֥饦</h4>
	<p><input type="radio" name="check_referer" value="true" #{if [1,3].include?(csrf_protection_method) then " checked" end}>(ɸ)</input>
	<input type="radio" name="check_referer" value="false" #{if [0,2].include?(csrf_protection_method) then " checked" end}>ʤ</input>
	</p>
	#{"<p>֥饦RefererƤʤäưꤷޤ</p>
	<p>ɸǤϡRefererФʤ硢ʥꥯȤ
	Ƚ̤Ǥʤᡢ񤭹ߡѹݤޤ
	ʤΥ֥饦RefererФʤξ硢
	꤬֤פˤʤäƤȡν񤭹׵ݤƤޤޤ
	֥饦ѹRefererФ褦ˤƤ
	ɤƤRefererФ˽ʤ硢֤ʤפˤƤ
	ξ硢RefererФʤäˤ⡢
	񤭹ߡѹ褦ˤʤޤ
	CSRFˤ빶ȶ̤ǤʤʤޤΤǡɬΡCSRFɻߥפ
	ʻѤƲ</p>
	</div>
	" unless @conf.mobile_agent?}
	<div class="section">
	<h3 class="subtitle">CSRFɻߥˤɱ</h3>
	<h4>CSRFɻߥθ</h4>
	<p><input type="radio" name="check_key" value="true" #{if [2,3].include?(csrf_protection_method) then " checked" end}></input>
	<input type="radio" name="check_key" value="false" #{if [0,1].include?(csrf_protection_method) then " checked" end}>ʤ(ɸ)</input>
	</p>
	#{"<p>񤭹ߥե˵񤭹ɻߤΤΥꤷCSRFɤޤ
	ڡ̩ΥΤʤ¤ꡢ
	ν񤭹׵뤳ȤǤʤʤޤ
	θ֤פꤹ硢θꤷƲ
	ξ֤ʤפˤ뤳ȤϤǤޤ</p>
	<p>֤פˤ硢εбƤʤ
	ץ饰ưʤʤ뤳Ȥޤ</p>
	" unless @conf.mobile_agent?}
	<h4>CSRF ɻߥ</h4>
	<p><input type="text" name="key" value="#{CGI::escapeHTML csrf_protection_key}" size="30"></p>
	#{"<p>ɻߥꤷޤ¬ˤŬʸꤷƲ
	θ˱̤ȡCSRFǽޤ
	¾ΥѥɤȶѤϤƤϤޤ󡣤ʤꤷʸ򤢤ʤФƤɬפϤޤ</p>" unless @conf.mobile_agent?}
	#{"<p class=\"message\">: 
	ʤΥ֥饦ϸRefererФƤʤ褦Ǥ
	<a href=\"#{@conf.update}?conf=csrf_protection\">Υ󥯤⤦
	Υڡ򳫤ƤߤƲ</a>
	Ǥ⤳ΥåФǤϡѤ硢
	ŪRefererФˤ뤫
	ľtdiary.confԽƲ</p>
	</div>" if [1,3].include?(csrf_protection_method) && ! @cgi.referer && !@cgi.valid?('referer_exists')}
	HTML
end
