"""
There is a bug in the askyesno return value in the original 
tkMessageBox. To fix that, I have written this workaround.

Most code here is taken from the tkMessageBox.py file, originally
created by Fredrik Lundh, May 1997.

Written by Marc Boeren, Jan 2004.

usage:
#from tkMessageBox import askyesno
from bugfix_askyesno import fixed_askyesno as askyesno
"""
from tkMessageBox import Message

def _show(title=None, message=None, icon=None, type=None, **options):
    if icon:    options["icon"] = icon
    if type:    options["type"] = type
    if title:   options["title"] = title
    if message: options["message"] = message
    return Message(**options).show()

QUESTION = "question"
YESNO = "yesno"
YES = "yes"

def fixed_askyesno(title=None, message=None, **options):
    "Ask a question; return true if the answer is yes"
    s = _show(title, message, QUESTION, YESNO, **options)
    return s == YES or s == True

# --------------------------------------------------------------------
# test stuff

if __name__ == "__main__":
    print "yes/no", fixed_askyesno("Spam", "Got it?")
