"""ThudBoard skins

Version 1.2
Copyright 2003, 2004 by Marc Boeren
"""

import Tkinter as tk
import os
#import os.path

_relativedir = 'img'

def _loadimg(skindir, name):
    try:
        img = tk.PhotoImage(file = os.sep.join([skindir, name]))
    except:
        img = tk.PhotoImage(file = os.sep.join([_relativedir, name]))
    return img

def _loadcolors(skindir):
    try:
        colors = file(os.sep.join([skindir, 'colors']))
    except:
        try: 
            colors = file(os.sep.join([_relativedir, 'colors']))
        except:
            colors = False
    color = dict()
    color['text'] = "black"
    color['score'] = "#e3d7a6"
    color['background'] = "white"
    if colors:
        for line in colors:
            name, value = line.strip().split(':', 1)
            if name.strip() in color:
                color[name.strip()] = value.strip()
        colors.close()
    return color

def init(skin = None):
    skindir = _relativedir
    if skin: skindir = skin
    class Container(object): pass
    container = Container()
    container.color = _loadcolors(skindir)
    container.bcktile = _loadimg(skindir, 'bcktile.gif')
    container.board = _loadimg(skindir, 'board.gif')
    container.boardgrid = _loadimg(skindir, 'board-grid.gif')
    container.dwarf = _loadimg(skindir, 'dwarf.gif')
    container.troll = _loadimg(skindir, 'troll.gif')
    container.stone = _loadimg(skindir, 'stone.gif')
    container.score = _loadimg(skindir, 'score.gif')
    container.thudtitle = _loadimg(skindir, 'thudtitle.gif')
    container.banner = _loadimg(skindir, 'banner.gif')
    container.list = _loadimg(skindir, 'list.gif')
    container.down = _loadimg(skindir, 'down.gif')
    container.lock = _loadimg(skindir, 'lock.gif')
    container.check = _loadimg(skindir, 'check.gif')
    container.submenutop = _loadimg(skindir, 'submenutop.gif')
    container.submenuitem = _loadimg(skindir, 'submenuitem.gif')
    container.submenusep = _loadimg(skindir, 'submenusep.gif')
    container.submenubottom = _loadimg(skindir, 'submenubottom.gif')
    container.copy = _loadimg(skindir, 'copy.gif')
    container.paste = _loadimg(skindir, 'paste.gif')
    container.noclip = _loadimg(skindir, 'noclip.gif')
    container.nopaste = _loadimg(skindir, 'nopaste.gif')
    container.info = _loadimg(skindir, 'info.gif')
    return container

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~#

if __name__=='__main__':
    print "This file is not meant to be executed. Run thud.py instead."""
