/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class VncViewer
extends Applet
implements Runnable,
WindowListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    String[] mainArgs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    ScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    AuthPanel authenticator;
    VncCanvas vc;
    OptionsFrame options;
    ClipboardFrame clipboard;
    RecordingFrame rec;
    Object recordingSync;
    String sessionFileName;
    boolean recordingActive;
    boolean recordingStatusChanged;
    String cursorUpdatesDef;
    String eightBitColorsDef;
    String socketFactory;
    String host;
    int port;
    String passwordParam;
    String encPasswordParam;
    boolean showControls;
    boolean offerRelogin;
    boolean showOfflineDesktop;
    int deferScreenUpdates;
    int deferCursorUpdates;
    int deferUpdateRequests;

    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    boolean bl = true;
                    Object var3_3 = null;
                    return bl;
                }
                this.stopRecording();
            }
        }
        return false;
    }

    void connectAndAuthenticate() throws Exception {
        Object object;
        if (this.encPasswordParam != null) {
            Object object2;
            Object object3;
            object = new byte[8];
            int n = this.encPasswordParam.length() / 2;
            if (n > 8) {
                n = 8;
            }
            int n2 = 0;
            while (n2 < n) {
                object3 = this.encPasswordParam.substring(n2 * 2, n2 * 2 + 2);
                object2 = new Integer(Integer.parseInt((String)object3, 16));
                object[n2] = ((Integer)object2).byteValue();
                ++n2;
            }
            object3 = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
            object2 = new DesCipher((byte[])object3);
            ((DesCipher)object2).decrypt((byte[])object, 0, (byte[])object, 0);
            this.passwordParam = new String((byte[])object);
        }
        if (this.passwordParam != null) {
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
                this.vncFrame.show();
            } else {
                this.validate();
            }
            if (!this.tryAuthenticate(this.passwordParam)) {
                throw new Exception("VNC authentication failed");
            }
            return;
        }
        object = new GridBagConstraints();
        object.gridwidth = 0;
        object.anchor = 18;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.ipadx = 100;
        object.ipady = 50;
        this.gridbag.setConstraints(this.authenticator, (GridBagConstraints)object);
        this.vncContainer.add(this.authenticator);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
        } else {
            this.validate();
            this.authenticator.moveFocusToPasswordField();
        }
        while (true) {
            AuthPanel authPanel = this.authenticator;
            synchronized (authPanel) {
                try {
                    this.authenticator.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.tryAuthenticate(this.authenticator.password.getText())) break;
            this.authenticator.retry();
        }
        this.vncContainer.remove(this.authenticator);
    }

    public void destroy() {
        System.out.println("Destroying applet");
        this.vncContainer.removeAll();
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        if (this.inSeparateFrame) {
            this.vncFrame.dispose();
        }
    }

    public synchronized void disconnect() {
        System.out.println("Disconnect");
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.inAnApplet) {
            this.showMessage("Disconnected");
        } else {
            System.exit(0);
        }
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
    }

    public synchronized void fatalError(String string) {
        System.out.println(string);
        if (this.inAnApplet) {
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }

    public synchronized void fatalError(String string, Exception exception) {
        if (this.rfb != null) {
            if (this.rfb.closed()) {
                System.out.println("RFB thread finished");
                return;
            }
            this.rfb.close();
        }
        exception.printStackTrace();
        System.out.println(string);
        if (this.inAnApplet) {
            this.showMessage(string);
        } else {
            System.exit(1);
        }
    }

    public void init() {
        this.readParameters();
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("TightVNC");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        this.recordingSync = new Object();
        this.options = new OptionsFrame(this);
        this.clipboard = new ClipboardFrame(this);
        this.authenticator = new AuthPanel();
        if (RecordingFrame.checkSecurity()) {
            this.rec = new RecordingFrame(this);
        }
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
        }
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    public static void main(String[] stringArray) {
        VncViewer vncViewer = new VncViewer();
        vncViewer.mainArgs = stringArray;
        vncViewer.inAnApplet = false;
        vncViewer.inSeparateFrame = true;
        vncViewer.init();
        vncViewer.start();
    }

    void moveFocusToDesktop() {
        if (this.vncContainer != null) {
            if (this.vc != null && this.vncContainer.isAncestorOf(this.vc)) {
                this.vc.requestFocus();
            } else if (this.vncContainer.isAncestorOf(this.authenticator)) {
                this.authenticator.moveFocusToPasswordField();
            }
        }
    }

    int readIntParameter(String string, int n) {
        int n2;
        block2: {
            String string2 = this.readParameter(string, false);
            n2 = n;
            if (string2 == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(String.valueOf(string) + " parameter not specified");
            }
            return string2;
        }
        int n = 0;
        while (n < this.mainArgs.length) {
            if (this.mainArgs[n].equalsIgnoreCase(string)) {
                try {
                    return this.mainArgs[n + 1];
                }
                catch (Exception exception) {
                    if (bl) {
                        this.fatalError(String.valueOf(string) + " parameter not specified");
                    }
                    return null;
                }
            }
            n += 2;
        }
        if (bl) {
            this.fatalError(String.valueOf(string) + " parameter not specified");
        }
        return null;
    }

    public void readParameters() {
        this.host = this.readParameter("HOST", this.inAnApplet ^ true);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        String string = this.readParameter("PORT", true);
        this.port = Integer.parseInt(string);
        if (this.inAnApplet && (string = this.readParameter("Open New Window", false)) != null && string.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.encPasswordParam = this.readParameter("ENCPASSWORD", false);
        if (this.encPasswordParam == null) {
            this.passwordParam = this.readParameter("PASSWORD", false);
        }
        this.showControls = true;
        string = this.readParameter("Show Controls", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.showControls = false;
        }
        this.offerRelogin = true;
        string = this.readParameter("Offer Relogin", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.offerRelogin = false;
        }
        this.showOfflineDesktop = false;
        string = this.readParameter("Show Offline Desktop", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.showOfflineDesktop = true;
        }
        this.deferScreenUpdates = this.readIntParameter("Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter("Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter("Defer update requests", 50);
        this.socketFactory = this.readParameter("SocketFactory", false);
    }

    public void run() {
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        if (this.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
            this.vncContainer.add(this.buttonPanel);
        }
        try {
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            this.vc = new VncCanvas(this);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            if (this.inSeparateFrame) {
                Panel panel = new Panel();
                panel.setLayout(new FlowLayout(0, 0, 0));
                panel.add(this.vc);
                this.desktopScrollPane = new ScrollPane(0);
                gridBagConstraints.fill = 1;
                this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
                this.desktopScrollPane.add(panel);
                this.vncFrame.add(this.desktopScrollPane);
                this.vncFrame.setTitle(this.rfb.desktopName);
                this.vncFrame.pack();
                this.vc.resizeDesktopFrame();
            } else {
                this.gridbag.setConstraints(this.vc, gridBagConstraints);
                this.add(this.vc);
                this.validate();
            }
            if (this.showControls) {
                this.buttonPanel.enableButtons();
            }
            this.moveFocusToDesktop();
            this.vc.processNormalProtocol();
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this.fatalError("Network error: no route to server: " + this.host, noRouteToHostException);
        }
        catch (UnknownHostException unknownHostException) {
            this.fatalError("Network error: server name unknown: " + this.host, unknownHostException);
        }
        catch (ConnectException connectException) {
            this.fatalError("Network error: could not connect to server: " + this.host + ":" + this.port, connectException);
        }
        catch (EOFException eOFException) {
            if (this.showOfflineDesktop) {
                eOFException.printStackTrace();
                System.out.println("Network error: remote side closed connection");
                if (this.vc != null) {
                    this.vc.enableInput(false);
                }
                if (this.inSeparateFrame) {
                    this.vncFrame.setTitle(String.valueOf(this.rfb.desktopName) + " [disconnected]");
                }
                if (this.rfb != null && !this.rfb.closed()) {
                    this.rfb.close();
                }
                if (this.showControls && this.buttonPanel != null) {
                    this.buttonPanel.disableButtonsOnDisconnect();
                    if (this.inSeparateFrame) {
                        this.vncFrame.pack();
                    } else {
                        this.validate();
                    }
                }
            } else {
                this.fatalError("Network error: remote side closed connection", eOFException);
            }
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string != null && string.length() != 0) {
                this.fatalError("Network Error: " + string, iOException);
            } else {
                this.fatalError(iOException.toString(), iOException);
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null && string.length() != 0) {
                this.fatalError("Error: " + string, exception);
            }
            this.fatalError(exception.toString(), exception);
        }
    }

    void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setEncodings() {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeSetEncodings(this.options.encodings, this.options.nEncodings);
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setRecordingStatus(String string) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = string;
            this.recordingStatusChanged = true;
        }
    }

    void showMessage(String string) {
        this.vncContainer.removeAll();
        Label label = new Label(string, 1);
        label.setFont(new Font("Helvetica", 0, 12));
        if (this.offerRelogin) {
            Panel panel = new Panel(new GridLayout(0, 1));
            Panel panel2 = new Panel(new FlowLayout(0));
            panel2.add(panel);
            this.vncContainer.setLayout(new FlowLayout(0, 30, 16));
            this.vncContainer.add(panel2);
            Panel panel3 = new Panel(new FlowLayout(1));
            panel3.add(label);
            panel.add(panel3);
            panel.add(new ReloginPanel(this));
        } else {
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
        } else {
            this.validate();
        }
    }

    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                this.cursorUpdatesDef = this.options.choices[3].getSelectedItem();
                this.eightBitColorsDef = this.options.choices[5].getSelectedItem();
                this.options.choices[3].select("Disable");
                this.options.choices[3].setEnabled(false);
                this.options.setEncodings();
                this.options.choices[5].select("No");
                this.options.choices[5].setEnabled(false);
                this.options.setColorFormat();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options.choices[3].select(this.cursorUpdatesDef);
                this.options.choices[3].setEnabled(true);
                this.options.setEncodings();
                this.options.choices[5].select(this.eightBitColorsDef);
                this.options.choices[5].setEnabled(true);
                this.options.setColorFormat();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    boolean tryAuthenticate(String string) throws Exception {
        this.rfb = new RfbProto(this.host, this.port, this);
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        int n = this.rfb.readAuthScheme();
        block0 : switch (n) {
            case 1: {
                System.out.println("No authentication needed");
                return true;
            }
            case 2: {
                int n2;
                byte[] byArray = new byte[16];
                this.rfb.is.readFully(byArray);
                if (string.length() > 8) {
                    string = string.substring(0, 8);
                }
                if ((n2 = string.indexOf(0)) != -1) {
                    string = string.substring(0, n2);
                }
                byte[] byArray2 = new byte[8];
                System.arraycopy(string.getBytes(), 0, byArray2, 0, string.length());
                DesCipher desCipher = new DesCipher(byArray2);
                desCipher.encrypt(byArray, 0, byArray, 0);
                desCipher.encrypt(byArray, 8, byArray, 8);
                this.rfb.os.write(byArray);
                int n3 = this.rfb.is.readInt();
                switch (n3) {
                    case 0: {
                        System.out.println("VNC authentication succeeded");
                        return true;
                    }
                    case 1: {
                        System.out.println("VNC authentication failed");
                        break block0;
                    }
                    case 2: {
                        throw new Exception("VNC authentication failed - too many tries");
                    }
                }
                throw new Exception("Unknown VNC authentication result " + n3);
            }
            default: {
                throw new Exception("Unknown VNC authentication scheme " + n);
            }
        }
        return false;
    }

    public void update(Graphics graphics) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (this.vncFrame.isAncestorOf(this.authenticator)) {
            this.authenticator.moveFocusToPasswordField();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Closing window");
        if (this.rfb != null) {
            this.disconnect();
        }
        this.vncFrame.dispose();
        if (!this.inAnApplet) {
            System.exit(0);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

