/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class AuthUnixLoginPanel
extends Panel
implements ActionListener {
    Label titleLabel = new Label("Unix Login Authentication", 1);
    Label retryLabel;
    Label passwordPromptLabel;
    Label usernamePromptLabel;
    TextField usernameField;
    TextField passwordField;
    Button okButton;

    public AuthUnixLoginPanel() {
        this.titleLabel.setFont(new Font("Helvetica", 1, 18));
        this.usernamePromptLabel = new Label("Login:", 1);
        this.passwordPromptLabel = new Label("Password:", 1);
        this.usernameField = new TextField(10);
        this.usernameField.setForeground(Color.black);
        ((Component)this.usernameField).setBackground(Color.white);
        this.passwordField = new TextField(10);
        this.passwordField.setForeground(Color.black);
        ((Component)this.passwordField).setBackground(Color.white);
        this.passwordField.setEchoChar('*');
        this.okButton = new Button("OK");
        this.retryLabel = new Label("", 1);
        this.retryLabel.setFont(new Font("Courier", 1, 16));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
        this.add(this.titleLabel);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.retryLabel, gridBagConstraints);
        this.add(this.retryLabel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.usernamePromptLabel, gridBagConstraints);
        this.add(this.usernamePromptLabel);
        gridBagConstraints.ipadx = 10;
        gridBagLayout.setConstraints(this.usernameField, gridBagConstraints);
        this.add(this.usernameField);
        this.usernameField.addActionListener(this);
        gridBagConstraints.ipadx = 0;
        gridBagLayout.setConstraints(this.passwordPromptLabel, gridBagConstraints);
        this.add(this.passwordPromptLabel);
        gridBagConstraints.ipadx = 10;
        gridBagLayout.setConstraints(this.passwordField, gridBagConstraints);
        this.add(this.passwordField);
        this.passwordField.addActionListener(this);
        gridBagConstraints.ipady = 10;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.add(this.okButton);
        this.okButton.addActionListener(this);
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.usernameField) {
            this.passwordField.requestFocus();
        } else if (actionEvent.getSource() == this.passwordField || actionEvent.getSource() == this.okButton) {
            this.usernameField.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.notify();
        }
    }

    public void moveFocusToDefaultField() {
        if (this.usernameField.getText().length() == 0) {
            this.usernameField.requestFocus();
        } else {
            this.passwordField.requestFocus();
        }
    }

    public void retry() {
        this.retryLabel.setText("Sorry. Try again.");
        this.usernameField.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.passwordField.setText("");
        this.moveFocusToDefaultField();
    }

    public synchronized boolean tryAuthenticate(RfbProto rfbProto) throws Exception {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        String string = this.usernameField.getText();
        String string2 = this.passwordField.getText();
        rfbProto.writeInt(string.length());
        rfbProto.writeInt(string2.length());
        rfbProto.os.write(string.getBytes());
        rfbProto.os.write(string2.getBytes());
        int n = rfbProto.is.readInt();
        switch (n) {
            case 0: {
                System.out.println("Authentication succeeded");
                return true;
            }
            case 1: {
                System.out.println("Authentication failed");
                break;
            }
            case 2: {
                throw new Exception("Authentication failed - too many tries");
            }
            default: {
                throw new Exception("Unknown authentication result " + n);
            }
        }
        return false;
    }
}

