proc preproc {xmsg id} {
    set msg [string trim $xmsg]
    if {!$::TIK(options,usepreproc)} {
	    return $msg
    }
    if {[regexp -nocase -- {(/[a-z0-9]+)} $msg]} {
        if {[info exists ::TIK(bcastavail)]} {
            if {[regexp -nocase -- {^/b.*cast\s+(.+)$} $msg match mymsg]} {
                bcast::broadcast $mymsg
	        set msg ""
            }
        } 
        if {[regexp -nocase -- {^/(lit|literal|pre)\s(.+)$} $msg match match mymsg]} {
            return $mymsg
        } elseif {[regexp -nocase -- {^/msg\s+([[:alnum:]]+)\s+(.+)$} $msg match nick mymsg]} {
            toc_send_im $::NSCREENNAME [normalize $nick] $mymsg
            set msg ""
        } elseif {[regexp -nocase -- {^/eval\s+(.+)$} $msg match mymsg]} {
            eval $mymsg
            set msg ""
        } elseif {[regexp -nocase -- {^/(exec|local)\s+(.+)$} $msg match match mymsg]} {
            catch {eval exec $mymsg} msg
        } elseif {[regexp -nocase -- {^/rot([0-9]*)\s+(.+)$} $msg match n mymsg]} {
            if {[string length $n] == 0} {
                set msg [rot13 $mymsg]
            } else {
                set msg [rotn $n $mymsg]
            }
        } elseif {[regexp -nocase -- {^/nick\s+(.+)$} $msg match mymsg]} {
            toc_format_nickname $::NSCREENNAME $mymsg
            set msg ""
        } elseif {($id != -1) && [regexp -nocase -- {^/ignore\s+(.+)$} $msg match mymsg]} {
            p_tik_ignore $id $mymsg
            set msg ""
        } elseif {[regexp -nocase -- {^/ignore\s+.+$} $msg]} {
            set msg ""
        } elseif {[regexp -nocase -- {^/(crazy|eleet|lame)\s+(.+)$} $msg match match mymsg]} {
            set msg [lame $mymsg]
        } elseif {[regexp -nocase -- {^/(bw|rev)\s+(.+)$} $msg match match mymsg]} {
            set msg [strrev $mymsg]
        } elseif {[regexp -nocase -- {^/passw(or)?d\s+([^\s]+)\s+([^\s]+)$} $msg match match oldp newp]} {
            toc_change_passwd $::NSCREENNAME $oldp $newp
            set msg ""
#            } elseif {[regexp -nocase -- {^/warn[ 	]+.+$} $msg]} {
#               regsub -nocase -- {^/warn[ 	]+(.+)$} $msg {\1} mymsg
#                if { $id != -1 } {
#                    toc_chat_evil $::NSCREENNAME $id [normalize $mymsg] "anon"
#                }
#                set msg ""
        } elseif {[regexp -nocase -- {^/away\s+(.+)$} $msg match awaymsg]} {
            catch {away::set_away $awaymsg}
            set msg ""
        } elseif {[regexp -nocase -- {^/(away|back)$} $msg]} {
            catch {away::back}
            set msg ""
        } elseif {[regexp -nocase -- {^/(fortune|yow)$} $msg]} {
            set msg [eval exec $::TIK(options,fortuneprog)]
            return $msg
        } elseif {[regexp -nocase -- {^/(fortune|yow)\s+(.+)$} $msg match match mymsg]} { 
            set msg [eval exec $::TIK(options,fortuneprog) $mymsg] 
            return $msg
        } elseif {[regexp -nocase -- {^/(lookup|dict|webster|word|define)\s+(.+)$} $msg match match mymsg]} {
            set msg [eval exec $::TIK(options,websterprog) $mymsg]
            return $msg
        } elseif {[regexp -nocase -- {^/url\s+([^\s]+)\s*([^\s]*)} $msg match url anchor]} {
            if {[string length $anchor] == 0} {
                set msg "<a href=\"$url\">$url</a>"
            } else {
                set msg "<a href=\"$url\">$anchor</a>"
            }
            return $msg
        } elseif {[regexp -nocase -- {^/exit$} $msg]} {
            tik_signoff
            exit
        } elseif {[regexp -nocase -- {^/brb$} $msg]} {
            catch {away::set_away "brb"}
            set msg ""
        } elseif {[regexp -nocase -- {^/signoff} $msg]} {
            tik_signoff
            set msg ""
        } 
        regsub -nocase -all -- {^/time|(\s)/time} $msg "\\1[clock format [clock seconds] -format "%H:%M:%S"]" msg
        regsub -nocase -all -- {^/date|(\s)/date} $msg "\\1[clock format [clock seconds] -format "%b %d, %Y"]" msg
        regsub -nocase -all -- {^/day|(\s)/day} $msg "\\1[clock format [clock seconds] -format "%A"]" msg
        regsub -nocase -- {^/me} $msg "<-" msg
        regsub -nocase -all -- {(\s)/me} $msg "\\1$::SCREENNAME" msg
    }
    set temp [list]
    foreach line [split $msg \n] {
        set templine [list]
        foreach c [split $line] {
            if {![regexp -nocase -- {href} $c]} {
	        regsub -nocase -- {^(mailto|http|https|ftp|gopher|news|file|rlogin|telnet|nntp|tn3270)(:[^\s]+)} $c {<a href="\1\2">\1\2</a>} c
	        regsub -nocase -- {^(ftp|news|gopher)\.([-[:alnum:]]+\.)+(com|org|net|edu|gov|mil|[[:alpha:]]{2})(\/.*)?$} $c {<a href="\1://\0">\0</a>} c
	        regsub -nocase -- {^(ftp|news|gopher)\.([-[:alnum:]]+\.)+(com|org|net|edu|gov|mil|[[:alpha:]]{2})([^\w])} $c {<a href="\1://\1.\2\3">\1.\2\3</a>\4} c
	        regsub -nocase -- {^([-[:alnum:]]+\.)+(com|org|net|edu|gov|mil|[[:alpha:]]{2})(\/.*)?$} $c {<a href="http://\0">\0</a>} c
	        regsub -nocase -- {^(([-[:alnum:]]+\.)+)(com|org|net|edu|gov|mil|[[:alpha:]]{2})([^\w])} $c {<a href="http://\1\3">\1\3</a>\4} c
	        regsub -- {^[-\w\.]+\@[-[:alnum:]\.]+} $c {<a href="mailto:\0">\0</a>} c
            }
            regsub -all -- {\\n} $c "<br>" c
            lappend templine $c
        }
        set templine [join $templine]
        lappend temp $templine
    }
    set msg [join $temp \n]
    return $msg
}

proc rot13 {str} {
    return [rotn 13 $str]
}

proc rotn {n str} {
    if {$n <= 0} {
        return $str
    }
    set abc "abcdefghijklmnopqrstuvwxyz"
    set ABC "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

    set newline ""
    for {set i 0} {$i < [string length "$str"]} {incr i} {
        set char "[string index "$str" $i]"
        set j [string first "$char" "$abc"]
        if {$j != -1} {
            append rotated "[string index "$abc" [expr ($j+$n)%26]]"
            continue
        }
        set j [string first "$char" "$ABC"]
        if {$j != -1} {
            append rotated "[string index "$ABC" [expr ($j+$n)%26]]"
            continue
        }
        append rotated "$char"
    }
    return $rotated
}

proc lame {str} {    
    set str [string tolower $str]
    set fromstr "abcdefghijklmnopqrstuvwxyz012358?!"
    set tostr   "48D3FGH1JK1M0Q57VWXZSB"

    set newline ""
    for {set i 0} {$i < [string length "$str"]} {incr i} {
        set char "[string index "$str" $i]"
        set j [string first "$char" "$fromstr"]
        if {$j != -1} {
            append stupified "[string index "$tostr" $j]"
            if {[expr 2 * rand()] > 1} {
            
            }
            continue
        }
        append stupified "$char"
    }
    return $stupified
}

proc strrev {argstr} {
    set ist [split $argstr ""]
    set b ""

    foreach element $ist {
        set b [linsert $b 0 $element]
    }
    return [join $b ""]
}
