/*	$Id: config.h,v 1.1 2001/02/18 21:00:41 steve Exp $	*/

/*-
 * Copyright (c) 2001 Steve C. Woodford.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by Steve C. Woodford.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __config_h
#define __config_h

#define CFG_ARGC_ARGS_OPTIONAL	0x00000100
#define CFG_ARGC_COMPOUNDABLE	0x00000200
#define CFG_ARGC_MUST_COMPOUND	0x00000400
#define CFG_ARGC_MASK		0x000000ff

#define CFG_ARGC(n)	((n) & CFG_ARGC_MASK)

struct config_tokens {
	const char	*ct_tok;
	int		ct_argc;
	const char *	(*ct_func)(void *, char **, int, int, void *);
};

extern int	  config_init(void **, const char *);
extern void	  config_destroy(void *);
extern const char *config_err(void *, const char *, ...);
extern const char *config_parse(void *, struct config_tokens *, void *);
extern const char *config_boolean(void *, const char *, int *);
extern const char *config_integer(void *, const char *, int *);

#endif /* __config_h */
