/*	$Id: client.h,v 1.4 2003/04/13 09:26:04 steve Exp $	*/

/*-
 * Copyright (c) 2001 Steve C. Woodford.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by Steve C. Woodford.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __client_h
#define __client_h

#include <sys/queue.h>
#include "iocodes.h"

struct client_ctx;
struct context;

struct client_ops {
	const char *co_name;
	const char * (*co_cf_init)(void *, char **, int, int, void *);
	int	(*co_init)(struct client_ctx *, const void *);
	void	(*co_destroy)(struct client_ctx *);
	int	(*co_event)(struct client_ctx *, int);
	int	(*co_output)(struct client_ctx *, const char *, size_t,
		    struct client_ctx *);
	int	(*co_read_pending)(struct client_ctx *);
	int	(*co_write_pending)(struct client_ctx *);
	int	(*co_ioctl)(struct client_ctx *, int, void *,
		    struct client_ctx *);
};

struct client_options {
	int	co_readonly;
	int	co_allowbreak;
	int	co_timeout;
	int	co_suppressbanner;
};

struct client_ctx {
	TAILQ_ENTRY(client_ctx)	cc_qent;
	TAILQ_ENTRY(client_ctx)	cc_qent_parent;
	struct client_ctx	*cc_parent;
	struct client_ops	*cc_ops;
	struct client_options	cc_options;
	struct context		*cc_ctx;
	char			*cc_name;
	void			*cc_data;
	int			cc_fd;
};
TAILQ_HEAD(client_qhead, client_ctx);

extern int	client_init(struct client_ctx **, struct client_ctx *,
		    struct client_ops *, struct client_options *, const void *);
extern void	client_destroy(struct client_ctx *);

#define client_cf_init(cc,av,ac,ic,ap)				\
		(((cc)->cc_ops->co_cf_init != NULL) ?		\
		    (((cc)->cc_ops->co_cf_init)((cc),(av),(ac),(ic),(ap))) : 0)
#define client_event(cc,e)		(((cc)->cc_ops->co_event)((cc),(e)))
#define client_can_output(cc)	((cc)->cc_ops->co_output != NULL)
#define client_show_banner(cc)	((cc)->cc_options.co_suppressbanner == 0)
#define client_output(cc,b,l,s)					\
		(((cc)->cc_ops->co_output != NULL) ?		\
		    (((cc)->cc_ops->co_output)((cc),(b),(l),(s))) : 0)
#define client_read_pending(cc)					\
		(((cc)->cc_ops->co_read_pending != NULL) ?	\
		    (((cc)->cc_ops->co_read_pending)((cc))) : 1)
#define client_write_pending(cc)				\
		(((cc)->cc_ops->co_write_pending != NULL) ?	\
		    (((cc)->cc_ops->co_write_pending)((cc))) : 0)
#define client_ioctl(cc,c,a,s)					\
		(((cc)->cc_ops->co_ioctl != NULL) ?		\
		    (((cc)->cc_ops->co_ioctl)((cc),(c),(a),(s))) : (0))
#define client_getfd(cc)		((cc)->cc_fd)
#define client_getname(cc)		((cc)->cc_name)

#define CLIENT_IOCTL_NEW_CHILD		TITS_IOCODE(TITS_SUBSYS_CLIENT, 0)
#define CLIENT_IOCTL_CHILD_DELETED	TITS_IOCODE(TITS_SUBSYS_CLIENT, 1)

extern const char *cf_client_init(void *, char **, int, int, void *);
extern const char *cf_client_options(void *, struct client_options *);

#endif /* __client_h */
