/*	$Id: setup.c,v 1.3 2001/03/03 13:59:05 steve Exp $	*/

/*-
 * Copyright (c) 2001 Steve C. Woodford.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by Steve C. Woodford.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <errno.h>
#include <stdio.h>
#include <string.h>

#include "context.h"
#include "setup.h"
#include "config.h"

static const char *cf_global_include(void *, char **, int, int, void *);

static struct config_tokens cf_global_tokens[] = {
 {"include", 1,						     cf_global_include},
 {"context", CFG_ARGC_ARGS_OPTIONAL|CFG_ARGC_MUST_COMPOUND,  cf_context_init},
 {"service", CFG_ARGC_ARGS_OPTIONAL|CFG_ARGC_MUST_COMPOUND,  cf_context_init},
 {NULL, 0, NULL}
};


const char *
setup_parse(const char *fn)
{
	static char errbuff[128];
	void *cs;
	const char *err;

	if (config_init(&cs, fn) < 0) {
		snprintf(errbuff, sizeof(errbuff),
		    "%s: %s\n", fn, strerror(errno));
		return (errbuff);
	}

	err = config_parse(cs, cf_global_tokens, NULL);

	config_destroy(cs);

	return (err);
}

/* ARGSUSED */
static const char *
cf_global_include(void *cs, char **argv, int argc,
		  int is_compound, void *arg)
{
	void *newcs;
	const char *err;

	if (config_init(&newcs, argv[1]) < 0)
		return (config_err(cs, "%s", strerror(errno)));

	err = config_parse(newcs, cf_global_tokens, arg);

	config_destroy(newcs);

	return (err);
}
