#------------------------------------------------------------------------
# Epson scanner via SANE - epson-scanimage.tcl - ver 0.13
# 9 Jun 2001 - Masaki SHINOMIYA <shino@pos.to>
# This script supports only essential functions 
# just for the lowest models as GT-6700U/Perfection 640
# The gamma/dropout options do not work! Probably I made some mistakes. 
# For higher modeles, please add-on options  by yourself.
# 'scanimage --help' shows what options your scanner supports.
#------------------------------------------------------------------------

# Full scanning size. This should be in inches.
set s(scanwidth)	8.448
set s(scanheight)	11.68

# Minimum, maximum and step of scanning resolution in dpi
set s(resolutionRange)	{5 600 5}
# resolutions which your scanner realy supports
set s(resolutionSupported) {75 150 300 600}

# Time(in miliseconds) for coming back from the opposite end 
# after finishing full height scanning
set s(scantime)		20000

# Command-line driver
set s(command)	"scanimage"

# Scanner device (leave empty for autodetection)
set s(device)		"epson"

# Options other than for mode and resolution
#     Label         Type  Variable      Values or Range  Default value
set s(optionList) { 
    { {Speed}          m  speed  {yes no} no }
    { {Dropout}        m  dropout {None Red Green Blue} None}
    { {Gamma}          r  gamma         {0.5 2.5 0.1}  1.0 }
    { {Gamma Red}      r  gamma_red     {0.5 2.5 0.1}  1.0 }
    { {Gamma Blue}     r  gamma_blue    {0.5 2.5 0.1}  1.0 }
    { {Gamma Green}    r  gamma_green   {0.5 2.5 0.1}  1.0 }
}

set s(modedepoptionList) { dropout gamma gamma_red gamma_blue gamma_green }

# Supported scanning modes
#     Mode   Format  bpp  Mode-dependent options
set s(modeList) {
    { Lineart   pbm   1  {dropout}     }
    { Halftone  pbm   1  {dropout}       }
    { Gray      pgm   8  {dropout gamma}   }
    { Color     ppm  24  {gamma gamma_red gamma_green gamma_blue} }
}


set s(halftoning_support)	0

# Options the driver supports
# 1 : support by scanner driver
# 0 : support by external (image editor, image converter) commands
set s(halftoning_support)	0
set s(gamma_support)	    0

#------------------------------------------------------------------------
# Procedure launching scanner driver
#------------------------------------------------------------------------

proc run_scanner_driver { i file } { global s c
    set command $s(command)
    set prefix $file
    set tempfile  "$c(tkscandir)/$file.tmp"
    set file "$c(tkscandir)/$file.pnm"
    foreach j {tx ty bx by} { set $j [pixelto mm [expr $s($j$i)-$s(o)]] }
    set wd [expr $bx-$tx]
    set ht [expr $by-$ty]
    set geometry "-l $tx -t $ty -x $wd -y $ht"
    switch $s(mode) { 
        Lineart		{ 
               if $s(halftoning_support) {
                      set mode "--mode Binary --halftoning None"
               } else {
                      set mode "--mode Binary"
               }
                      set post "$tempfile pbm:$file"
           }
        Halftone    { 
               if $s(halftoning_support) {
                      set mode "--mode Binary"
                      set post "$tempfile pbm:$file"
               } else {
                      set mode "--mode Gray"
                      set post "-dither -monocrome $tempfile pbm:$file"
              }
            }
        Gray		{ set mode "--mode Gray"
                      set post "$tempfile pgm:$file" }
        Color		{ set mode "--mode Color"
                      set post "$tempfile ppm:$file" }
    }
    set reso 0
    foreach j $s(resolutionSupported) {
		if { $reso==0 && $s(resolution)<[expr 1.2*$j] } { set reso $j }
	}
    set resolution "--resolution $reso"

    if { $s(device) != "" } {
             set device "--device-name $s(device)"
    } else { set device "" }

    set option ""
    if { $s(speed) != "no" } {append option " --speed $s(speed)"}
    foreach i $s($s(mode)option) { switch $i {
      dropout {
          if { $s(dropout) != "None" } { append option " --dropout $s(dropout)" }
      }
      gamma { if $s(gamma_support) {
          append option " --gamma-table [gamma_table $s(gamma)]"
      }}
      gamma_red { if $s(gamma_support) {
          append option " --red-gamma-table [gamma_table $s(gamma_red)]"
      }}
      gamma_green { if $s(gamma_support) {
          append option " --green-gamma-table [gamma_table $s(gamma_green)]"
      }}
      gamma_blue { if $s(gamma_support) {
          append option " --blue-gamma-table [gamma_table $s(gamma_blue)]"
      }}
    }}
    set unit mm
    set wd [expr int($s(resolution)*$wd/$s(c$unit))] 
    set ht [expr int($s(resolution)*$ht/$s(c$unit))]
    set cmdline "$command $device $mode $resolution $option $geometry \
                 > $tempfile; convert -geometry ${wd}x${ht} $post &"
### for debugging
#
#      tk_messageBox -message $cmdline  -type ok
###
    exec sh -c "$cmdline"
 }

