#------------------------------------------------------------------------
# HP SCSI scanner -- hpscanpbm
# Jun 9 2001 Masaki Shinomiya -- halftoning and gamma switch
#------------------------------------------------------------------------

# Full scanning size. This should be in inches.
set s(scanwidth)	8.5
set s(scanheight)	11.6

# Minimum, maximum and step of scanning resolution in dpi
set s(resolutionRange)	{1 800 1}

# Time(in miliseconds) for coming back from the opposite end 
# after finishing full height scanning
set s(scantime)		20000

# Command-line driver
set s(command)	"hpscanpbm"

# Scanner device (leave empty for autodetection)
set s(device)		""

# Options other than for mode and resolution
#     Label         Type  Variable      Values or Range  Default value
set s(optionList) { 
    { {Brightness}     r  brightness    {-1.0 1.0 0.1}  0.0 }
    { {Contrast}       r  contrast      {-1.0 1.0 0.1}  0.0 }
    { {Gamma}          r  gamma         {0.2 5.0 0.1}  2.0 }
    { {Gamma Red}      r  gamma_red     {0.2 5.0 0.1}  1.0 }
    { {Gamma Blue}     r  gamma_blue    {0.2 5.0 0.1}  1.0 }
    { {Gamma Green}    r  gamma_green   {0.2 5.0 0.1}  1.0 }
}
set s(modedepoptionList) {gamma gamma_red gamma_blue gamma_green}

# Supported scanning modes
#     Mode   Format  bpp  Mode-dependent options
set s(modeList) {
    { Lineart   pbm   1  {} }
    { Halftone  pbm   1  {} }
    { Gray      pgm   8  {gamma}                                  }
    { Color     ppm  24  {gamma gamma_red gamma_green gamma_blue} }
}

# Options the driver supports
# 1 : support by scanner driver
# 0 : support by external (image editor, image converter) commands
set s(halftoning_support)	1
set s(gamma_support)	    0

#------------------------------------------------------------------------
# Procedure launching scanner driver
#------------------------------------------------------------------------

proc run_scanner_driver { i file } { global s c
    set command $s(command)
    set file "> $c(tkscandir)/$file.pnm"
    foreach j {tx ty bx by} { set $j [pixelto inch [expr $s($j$i)-$s(o)]] }
    set wd [expr $bx-$tx]
    set ht [expr $by-$ty]
    set geometry "-x $tx -y $ty -width $wd -height $ht"
    switch $s(mode) {
        Lineart		{ set mode "-format thresholded" }
        Halftone	{ set mode "-format dithered" }
        Gray		{ set mode "-format grayscale" }
        Color		{ set mode "-format color" }
    }
    set resolution "-dpi $s(resolution)"
    set option "-quiet -cont $s(contrast) -bright $s(brightness)"
    set cmdline "$command $mode $resolution $option $geometry $file"
    exec sh -c "$cmdline" &
}

