#------------------------------------------------------------------------
# Mustek Paragon 600(800) II SP scanner
# Jun 9 2001 Masaki Shinomiya -- halftoning and gamma switch
#------------------------------------------------------------------------

# Full scanning size. This should be in inches.
set s(scanwidth)	8.5
set s(scanheight)	11.6

# Minimum, maximum and step of scanning resolution in dpi
set s(resolutionRange)	{1 800 1}

# Time(in miliseconds) for coming back from the opposite end 
# after finishing full height scanning
set s(scantime)		20000

# Command-line driver
set s(command)	"mscan"

# Scanner device (leave empty for autodetection)
set s(device)		""

# Options other than for mode and resolution
#     Label         Type  Variable      Values or Range  Default value
set s(optionList) { 
    { {Backtrack}      m  backtrack     {yes no}  yes }
    { {Speed}          r  speed         {0 100 1}  50 }
    { {Grain}          m  grain         {2 3 4 5 6 8}  2 }
    { {Brightness}     r  brightness    {-100 100 1}  0 }
    { {Contrast}       r  contrast      {-100 100 1}  0 }
    { {Gamma}          r  gamma         {0.2 5.0 0.1}  2.0 }
    { {Gamma Red}      r  gamma_red     {0.2 5.0 0.1}  1.0 }
    { {Gamma Blue}     r  gamma_blue    {0.2 5.0 0.1}  1.0 }
    { {Gamma Green}    r  gamma_green   {0.2 5.0 0.1}  1.0 }
}
set s(modedepoptionList) { gamma gamma_red gamma_blue gamma_green }

# Supported scanning modes
#     Mode   Format  bpp  Mode-dependent options
set s(modeList) {
    { Lineart   pbm   1  {} }
    { Halftone  pbm   1  {} }
    { Gray      pgm   8  {gamma}                                  }
    { Color     ppm  24  {gamma gamma_red gamma_green gamma_blue} }
}

# Options the driver supports
# 1 : support by scanner driver
# 0 : support by external (image editor, image converter) commands
set s(halftoning_support)	1
set s(gamma_support)	    0

#------------------------------------------------------------------------
# Procedure launching scanner driver
#------------------------------------------------------------------------

proc run_scanner_driver { i file } { global s c
    set command $s(command)
    set file "-f $c(tkscandir)/$file.pnm"
    foreach j {tx ty bx by} { set $j [pixelto mm [expr $s($j$i)-$s(o)]] }
    set wd [expr $bx-$tx]
    set ht [expr $by-$ty]
    set geometry "-l $tx -u $ty -x $wd -y $ht"
    switch $s(mode) {
        Lineart		{ set mode "-a" }
        Halftone	{ set mode "-m" }
        Gray		{ set mode ""   }
        Color		{ set mode "-c" }
    }
    set resolution "-r $s(resolution)"
    if {$s(device) == {}} { set device ""
                   } else { set device "$s(device)" }
    set option "-s $s(speed) -g $s(grain) -B $s(brightness) -C $s(contrast)"
    if {$s(backtrack) == "yes"} {append option "-b" }
    set cmdline "$command $mode $resolution $option $geometry $file $device"
    exec sh -c "$cmdline" &
}

