# This file is a part of TkFax.
# fax-init.tcl
#  17 Apr 2002
# This tcl script initiates TkFax.

# Read fax source files
source $fax(libdir)/fax-balloon.tcl
source $fax(libdir)/fax-about.tcl
source $fax(libdir)/fax-conf.tcl
source $fax(libdir)/fax-conf-win.tcl
source $fax(libdir)/fax-faxwin.tcl
source $fax(libdir)/fax-lib.tcl
source $fax(libdir)/fax-file.tcl
source $fax(libdir)/fax-mkpg.tcl
source $fax(libdir)/fax-scan.tcl
source $fax(libdir)/fax-pbook.tcl
source $fax(libdir)/fax-queue.tcl
source $fax(libdir)/fax-received.tcl
source $fax(libdir)/fax-logbrowse.tcl

# Read scan source files
source $c(libdir)/scan-about.tcl
source $c(libdir)/scan-drivers/$scanner_driver.tcl
source $c(libdir)/scan-conf.tcl
source $c(libdir)/scan-lib.tcl
source $c(libdir)/scan-scan.tcl
source $c(libdir)/scan-out.tcl
source $c(libdir)/scan-scanwin.tcl
source $c(libdir)/scan-file.tcl
source $c(libdir)/scan-win.tcl

# 3 Sep 2001
set fax(userconfigfile) $fax(userdir)/config.tcl
set fax(pbookgroupfile)  /home/mshino/.tkfax/pbook/group.pbd

# Check if userdir exists. If not, create it.
fax_userdir_check

# Read user configuration file in if exists.
# 7 Sep 2001 check config_version
#fax_read_userconfig
# **** Variables do not change when this function reads user's config file!
# **** Next script works OK. (by R.Kawagishi)
set openingmsg ""
if [file exist $fax(userconfigfile)] {
    set fax(config_version) 0
    source $fax(userconfigfile)
    if { [string compare  $fax(config_version) "0.99b"] < 0 } {
         set openingmsg "old_config edit_config"
    }
} else {
    file copy $fax(libdir)/fax-conf.tcl $fax(userconfigfile)
    set openingmsg "new_config edit_config"
}

proc autolocale {} {
  global env fax c m
  # 23 Jan 2002 auto scan the lolale
  set fax(locale) $fax(usrlocale)
  set envlocale {}
  if { $fax(locale) == {}  } {
      if { [ info exists  env(LANG) ] } {
          set envlocale $env(LANG)
      } 
      if  { [ string length $envlocale ] >= 2 } {
          set fax(locale) [ string range $envlocale 0 1 ]
      }
  }
  # set locale and read messages
  source $c(libdir)/msg_C.tcl
  if { $fax(locale)=="" } { set fax(locale) "C" }
  if { $fax(locale)!="C"} { 
    if [file exists $c(libdir)/msg_$fax(locale).tcl] {
         source $c(libdir)/msg_$fax(locale).tcl
    }
  }
  return $fax(locale)
}

proc autoconfig {} {
  global env fax c m paperList openingmsg
  set e ""

  # file names
  set fax(flagfile)  $fax(tmpdir)/flag
  set fax(pbookgroupfile)  $fax(pbookdir)/group.pbd

  # initiate tkfax logfile
  set username [lindex [file split $fax(userdir)] 2]
  set tkfaxlog "tkfax_${username}.log"
  if [file writable $fax(logdir)] {
      set fax(tkfaxlogfile)  $fax(logdir)/$tkfaxlog
      set fax(startlogdir) $fax(logdir)
  } else {
      append e $fax(logdir)
      set fax(tkfaxlogfile)  $fax(userdir)/$tkfaxlog
      set fax(startlogdir) $fax(userdir)
  }
  set fid [open $fax(tkfaxlogfile) w]
  puts $fid "$fax(progname) version $fax(ex_version), $fax(ex_date)"
  puts $fid [ clock format [clock seconds] ]
  if { $e != "" } {
     set code [catch "close $fid"]
     catch [exec sh -c "ls -dl $fax(logdir)  >> $fax(tkfaxlogfile) 2>&1" ]
     set fid [open $fax(tkfaxlogfile) a]
     puts $fid "$e not available."
  }
  set code [catch "close $fid"]

  # Some xternal programs
  if { $fax(mpage) == "" } {
    if [excutable "a2ps"] {
      set fax(mpage) "a2ps --columns=1 --border no --margin=30 -R -B"
    } elseif [excutable "mpage"] {
      set fax(mpage) "mpage -1 -o -m30l"
    }
  }
  foreach i "kterm rxvt xterm" {
    if { $fax(xterm) == "" } { if [excutable $i] { set fax(xterm) $i } }
  }
  foreach i "lpr lp" {
    if { $fax(printcmd) == "" } { if [excutable $i] { set fax(printcmd) $i } }
  }
  if { $fax(faxagent) == "sendfax" } { set fax(faxagent) "faxspool" }
  foreach i "efax faxspool" {
    if { $fax(faxagent) == "" } { if [excutable $i] { set fax(faxagent) $i } }
  }
  foreach i "latex dvips" { 
      if { $fax($i) == "" } { if [excutable $i] { set fax($i) $i } }
  }
  if  { $fax(latex) == "" || $fax(dvips) == "" || $fax(latex) == "none" } {
      set fax(uselatex) 0
  } else {
      set fax(uselatex) 1
  }

  foreach i "mpage xterm printcmd faxagent" {
    if  { $fax($i) == "" } { append e "$i "
    } elseif { ! [excutable $fax($i)] } { append e "[lindex [split $fax($i) " "] 0], " }
  }

  # depends on the fax agent
  # 8 Sep 2001
  if { $fax(faxagent) == "faxspool" } {
      set fax(faxagent) {sendfax}
      set fax(sendfax)	{/usr/sbin/sendfax -v}
      set fax(receivefax)   {}
      set fax(faxspool)	{faxspool}
      set fax(faxqueue)	{faxq}
      set fax(faxrm) {faxrm}
      set fax(g32pbm)	{g32pbm}
      set fax(pbm2g3)	{pbm2g3}
  #  if  { $fax(viewer) == {} } { set fax(viewer) "viewfax" }
  } else {
  # 16 Sep 2001 fax spooling using lpr
      set fax(sendfax)	{fax send -v}
      set fax(receivefax) {fax receive}
      set fax(faxspool)	{lpr -P fax -J}
      set fax(faxqueue)	{lpq -P fax}
      set fax(faxrm) {lprm -P fax}
      set fax(g32pbm)	{efix -i tiffg3 -o pbm}
      set fax(pbm2g3)	{efix -i pbm -o tiffg3}
  #  if  { $fax(viewer) == {} } { set fax(viewer) "fax view" }
  #  if  { $fax(printertype) == {} } { set fax(printertype) "efax" }
  }
  #  5 Mar 2002
  set c(pbmtofax) $fax(pbm2g3)

  autolocale

  # Using japanese require some special programs
  if { $fax(locale) == "ja" } {
      if { $fax(uselatex) && [ excutable "platex" ] } { set fax(latex) {platex} }
      #if [ excutable "kterm"] {
      #      set fax(xterm)	{kterm}
      #}
      #
      # 3 Sep 2001
      set p 0
      foreach lang $fax(custom) {
        if { [lindex $lang 0 ] == "Japan" } {
            set fax(custom) [lreplace $fax(custom) $p $p { {ܸ} ja }]
            set fax(customstyle) $p
        }
        set p [expr $p+1]
      }
      # 4 Sep 2001 for Tcl/Tk8.3
      catch { tk useinputmethods 1 }
  }
  # pdvips for RHL7.2
  if { $fax(latex) == "platex" && [ excutable "pdvips" ] } { set fax(dvips) {pdvips} }

  # calcurate dimensions
  # 4 Sep 2001 Asume printerYreso is = printerXreso 
  # 1 Sep 2001
  if { $fax(printerYreso) == 0 } { set fax(printerYreso) $fax(printerXreso) }
  foreach j {fax printer} {
    set flag {}
    while { $flag == {} } {
       foreach i $paperList {
       set P  [lindex $i 0]  
         if { $P == $fax(${j}Paper) } {
            set flag P
            set size(X) [lindex $i 1]
            set size(Y) [lindex $i 2]
         }
      }
      if { $flag == {} } { set flag {a4}; set fax(${j}Paper $flag }
    }
    foreach i {X Y} {
      set fax($j${i}inch) $size($i)
      set fax($j${i}dots) [ expr 8*int(($size($i)-2*$fax($j${i}margin))*$fax($j${i}reso)/8) ]
    }
  }

  # 
  if  [ info exists  env(DEBUG) ] { set fax(debug) $env(DEBUG) } 

  return $e
}

# load message
autolocale

# Lock tmpdir
set lockfile $fax(tmpdir)/lock
set fax(lockfile) $lockfile
if [file exists $lockfile] {
        if  [tk_dialog .dialog "TkFax lock file found" \
            $m(multi_run)  \
             {warning} 1 $m(confirm) $m(cancel)] { exit }
}
set fid [open $lockfile w]
close $fid

# Check the configuration
set e [autoconfig]
if { $e != "" } { set openingmsg "$e is_not_available" }

# Build up phone book database
fax_pbook_read_faxnumberlist

# Initialize some variables
#
set fax(c) 0
fax_number_clear
set fax(queuelist) 0

# Launch the main window
# 20 Sep 2001 --debug
set arg1 [lindex $argv 0]
switch -- $arg1 {
    -r fax_received_window
    -q fax_queue_window
    --debug -
    -debug
       { set fax(debug) 1
         fax_main_window {}
        }
    -s -
    default {fax_main_window {}}
}

# 19 Sep 2001 opening message
set msg ""
if { $openingmsg != "" } {
   set msg ""
   foreach i $openingmsg {
      if [ info exists m($i) ] {
      set msg "$msg $m($i)" } else { set msg "$msg $i" }
   }
   fax_message $msg
#   FaxConfigure
}

# End
