# This file is a part of TkFax.
# fax-lib.tcl
# Here we collect procedures used in other parts
#

proc fax_SEND {} {
#
# Procedure for sending faxes.
# 9 Jan 2002 check cover pages
# 7 Jan 2002 special charactors '#' to '_043', '*' to '_052'
# 16 Dec 2001 convert special charactors
# 25 Nov 2001 check $fax(queuelist)
# 20 Oct 2001 check $fax(queuelist)
# 19 Sep 2001 check fax number when spooling
# 16 Sep 2001 protect the fax number by single quatations 
# 1 Sep 2001 checking return code
    global fax m
    set m(procname) $m(send)
    fax_message "$m(procname):"
    # First check if fax page and fax number to be sent exist.

    if {$fax(c)<=0} {
        fax_message "$m(procname): $m(no_page_to_send)"
        return
    }

    if {$fax(number)=={} && $fax(spooling)} {
        fax_message "$m(procname): $m(fax_number_is_empty)"
        return
    }

    if {$fax(number)!={} } {
        if { [fax_check_cover] } { return 1 }
    }

    # Get a fax page list.

    for {set pages "" ; set i 0} {$i < $fax(c)} {incr i} {
        append pages " $fax(tmpdir)/$fax($i)"
    }

    # Run sendfax, or faxspool command if fax(spooling) is on.

    if $fax(spooling) { set faxcmd $fax(faxspool) } else {
                        set faxcmd $fax(sendfax)  }
    set faxnum $fax(number)
    if { $faxnum == "" } { set faxnum "-m"
    } elseif { $fax(faxagent) == "efax" && $fax(spooling) } {
        set faxnum [num_encode $faxnum]
    }

    set tempfile $fax(tmpdir)/flag.tmp
    set command "$faxcmd '$faxnum' $pages"
    cd $fax(tmpdir)
    if $fax(spooling) {
        set code [ fax_exec_flag $command ]
        if { ! $code } {
            fax_message $m(fax_to_spooler)
          if { "$fax(queuelist)" != "" } {
            if  [winfo exist $fax(queuelist)] {
                fax_queue_update
            }
          }
        }
    } else {
        set code [ fax_exec_xterm_wait $command ]
    }
    if { $code == 0 } {
#         fax_message "$m(procname): $m(successfully_sent)"   
         cd $fax(curdir)
         return 0
    }
    fax_check_log $fax(tmpdir)
    cd $fax(curdir)
    return $code
}

proc fax_RECEIVE {} {
#
# Procedure for recieving faxes.
# Aug31 2001 checking return code
    global fax m
    set m(procname) $m(receive)
    fax_message "$m(procname):"
#    set date [open "|date +%D%H%M%S"]
#    set Time [gets $date]
#    close $date
#    set command "$fax(receivefax) \
#        $fax(incomingdir)/`echo $Time | sed 's,/,,g'` "
    set tempfile $fax(tmpdir)/flag.tmp
    set command "$fax(receivefax)"
    cd $fax(incomingdir)
    set code [ fax_exec_xterm_wait $command ]
    if { $code == 0 } {
         fax_message "$m(procname): $m(successfully_received)"   
         cd $fax(curdir)
         fax_received_window
         return 0
    }
    fax_check_log $fax(incomingdir)
    cd $fax(curdir)
    return $code
}

# Detect (1)no covers (2)multiple covers (3)cover is not at the top (4)odd fax number
# 9 Jan 2002  Masaki Shinomiya
proc fax_check_cover {} {
    global fax m
    set count 0
    set pos 0
    set odd 0
    set files ""
    set oddfiles ""
    set faxnum [num_encode $fax(number)] 

   for {set i 0} {$i < $fax(c)} {incr i} {
        set file $fax($i)
        if { [string range $file 0 2] == "cvr" } {
             set num [string range $file 3 [expr [string length $file] - 8] ]
             if { "$num" != "$faxnum" } { set odd -1; set oddfiles "$oddfiles, $file" }
             if {  [string range $file [expr [string length $file]-7] end] == ".001.g3" } {
                 set files "$files, $file"
                 set count [expr $count + 1 ]
                 if { $i < [expr $fax(c) - 1 ] } { set pos $i }
             }
        }
    }
    set msg ""
    if { $odd } {
        eval set msg \"$m(odd_number_coverpage)\"
    } elseif { $count > 1 } {
        eval set msg \"$m(multiple_cover)\"
    } elseif { $pos } {
        eval set msg \"$m(not_at_the_top)\"
   }
    if { "$msg" != "" } {
        if { [tk_dialog .dialog "TkFax Warning" \
            "$msg $m(is_it_ok)" {warning} 1 $m(ok) $m(cancel) ] } {
            return 1
        }
    }
    return 0
}

# 22 Aug  2001 Masaki Shinomiya
proc fax_check_log { dir } {
    global fax m
    cd $dir
    set logfiles ""
    set filelist [exec ls]
    foreach j $filelist {
            if { [ string first ".log" $j ] >= 0 } {
                 set logfiles "$logfiles $j"
            }
    }
    if { $logfiles != "" } { 
        fax_exec "mv $logfiles $fax(logdir)"
        fax_message "$m(procname): $m(log_is_left_in) $fax(logdir)/$logfiles"
#        fax_log_browse
        return 1
    } else {
        return 0
    }
}

# 28 Jan 2002 flagfile ewxists?
# 31 Aug 2001 use $fax(flagfile)
# 14 Jun 2001 Masaki Shinomiya
proc fax_check_flag {} {
    global fax
    if [file exists  $fax(flagfile)] {
        set fid [open $fax(flagfile) r]
        set flag [gets $fid]
        close $fid
        exec rm -f $fax(flagfile)
        return $flag
    }
    fax_log "fax_check_flag: $fax(flagfile) not found."
    return -1
}

proc fax_addto_pagelist { faxes } {
#
# Add faxes to the fax page list.
#
    global fax
    foreach i $faxes {

        # ignore if the same name already in the list
        if $fax(c) {
            for { set j 0 } { $j < $fax(c) } { incr j } {
               if { $i == $fax($j) }  { return }
            }
        }

        set fax($fax(c)) $i
        incr fax(c)
    }
    fax_update_pagelist
}

proc fax_update_pagelist {} {
#
# Update the fax page list.
#
    global fax
    $fax(pagelist) delete 0 end
    for {set i 0} {$i < $fax(c)} {incr i} {$fax(pagelist) insert end $fax($i)}
}

proc fax_save_pagelist {} {
    global fax
    set file $fax(tmpdir)/pagelist
    set fileid [open $file w+]
     puts $fileid "set fax(c) $fax(c)"
     for {set i 0} {$i < $fax(c)} {incr i} {
           puts $fileid "set fax($i) \"$fax($i)\""
     }
    close $fileid
}


proc fax_clear_tmpdir {} {
#
# Delete all file in tmp dir.
#
    global fax
    fax_exec "rm -f $fax(tmpdir)/*"
}

proc fax_edit_config {} {
#
# Edit a user configuration file.
#
    global fax
    if ![file exist $fax(userconfigfile)] {
        exec cp $fax(libdir)/fax-conf.tcl $fax(userconfigfile)
    }
    fax_exec "$fax(editcmd) $fax(userconfigfile) 2> /dev/null"
    fax_message "Restart $fax(progname) to get the change of config file."
}

proc fax_exec { cmd } {
#
# Execute a command in shell in foreground.
# return stdout
# 2 Nov 2001 use fax_error 
#
    global fax errorInfo errorCode
    if { $fax(debug) > 1 } { tk_messageBox -message $cmd -icon info  -type ok }
#    if { $fax(debug) } { return [fax_exec_xterm_wait "$cmd"] }
    set code [catch { set result [exec sh -c "$cmd"]}]
    if $code {
           fax_error "$errorInfo\n$cmd"
            return ""
    }
    return $result
}

proc fax_exec_flag { cmd } {
#
# Execute a command in shell in foreground.
# return error code
# 1 Sep 2001
# 2 Nov 2001 use fax_error 
    global fax errorInfo errorCode
    if { $fax(debug) > 1 } { tk_messageBox -message $cmd  -icon info  -type ok }
#    if { $fax(debug) } { return [fax_exec_xterm_wait "$cmd"] }
    set code [catch { set result [exec sh -c "$cmd"]}]
    if $code {
            set log ""
            if [ file exist $fax(tkfaxlogfile) ] {
                set fid [open $fax(tkfaxlogfile) r]
                 set log [gets $fid]
                 close $fid
            }
             fax_error "$errorInfo\n$cmd\n$log"
             return $code
    }
    return $code
}

proc fax_exec_efix { cmd } {
#
# Execute efix command in shell in foreground.
# return error code
# 1 Sep 2001
# 2 Nov 2001 use fax_error 
    global fax errorInfo errorCode
    if { $fax(debug) > 1 } { tk_messageBox -message $cmd  -icon info  -type ok }
    if { $fax(debug) } { return [fax_exec_xterm_wait "$cmd"] }
    set code [catch { set result [exec sh -c "$cmd"]}]
    if { [ string first "Error:" $errorInfo ] >= 0 } {
            fax_error "$errorInfo\n$cmd"
            return 1
    }
    return 0
}

proc fax_exec_bg { cmd } {
#
# Execute a command in shell in background.
#
# 3 Sep 2001 leave log and return code
# 2 Nov 2001 use fax_error 
    global fax errorInfo errorCode
    set command "$cmd >> $fax(tkfaxlogfile) 2>&1 &"
    set code [catch { exec sh -c "$command" }]
    if $code {
            set log ""
            if [ file exist $fax(tkfaxlogfile) ] {
                set fid [open $fax(tkfaxlogfile) r]
                 set log [gets $fid]
                 close $fid
            }
            fax_error "$errorInfo\n$command\n$log"
    }
    return $code
}


proc fax_exec_fg { cmd } {
#
# Execute a command in shell in foreground.
#
  global fax
# $fax(textwindow) delete 1.0 end
  $fax(textwindow) insert end "$cmd\n" red
  set fax(pipe) [open "|/bin/sh -c \"$cmd\" 2>@stdout" r+]
# set fax(pid) [pid $fax(pipe)]
# lappend fax(processlist) [list $fax(pid) $cmd]
  fconfigure $fax(pipe) -buffering none -blocking 0
  fileevent $fax(pipe) readable fax_cmd_out
}

proc fax_exec_xterm { cmd } {
#
# Execute a command on xterm in foreground.
# 28 Jan 2002 use fax_xterm
# 19 Jan 2002 log xterm launching error
# 3 Sep 2001 for debugging
# 2 Nov 2001 use fax_error 
    global fax m
    if { $fax(debug) } { return [fax_exec_xterm_wait "$cmd"] } 
#    exec echo -n 0 > $fax(flagfile)
    set command \
             "echo -n 0 > $fax(flagfile); echo $cmd; $cmd || (echo -n $? > $fax(flagfile);echo \"$m(hit_return_to_finish)\" ;read)"
    fax_xterm $command
}


proc fax_exec_xterm_wait { cmd } {
#
# Execute a command on xterm and wait until Return key is hit.
# 28 Jan 2002 use fax_xterm
# 19 Jan 2002 log xterm launching error
# 1 Sep 2001 return flag
# 2 Nov 2001 use fax_error 
    global fax m
    fax_log $cmd
    set command "echo $cmd;$cmd;echo -n $? > $fax(flagfile);echo;echo \"$m(hit_return_to_finish)\" ;read"
    fax_xterm $command
}

# 28 Jan 2002 errorCode in xterm launching error
proc fax_xterm { cmd } {
    global fax m errorInfo errorCode
    if [catch { exec $fax(xterm) -e sh -c "$cmd" }] {
        fax_log "$errorCode: $errorInfo"       
        set code -1
    } else {
        set code [ fax_check_flag ]
    }
    if $code {
        set errmsg "Error code=$code\nwhile excuting:\n$cmd"
        fax_error $errmsg
   }
    return $code
}


# 19 Jan 2002
proc fax_error { errmsg } {
      global fax m
      fax_log $errmsg
       if [tk_dialog .dialog "TkFax: Error" \
        "$m(an_error_occured)" {error} 0 $m(yes) $m(no)] { return }
        fax_help "TkFax: Error log" $errmsg
}

# 19 Jan 2002
proc fax_log { msg } {
      global fax m
       set fid [open $fax(tkfaxlogfile) a]
       puts $fid $msg
       close $fid
}

proc fax_exit {} {
#
# This is for exiting TkFax.
#
    global fax

    # Save back fax number list.
    fax_pbook_save_faxnumberlist

    # Clear tmp dir if fax(cleartmpdiratexit) is on.
    if $fax(cleartmpdiratexit) { fax_clear_tmpdir } else {
        fax_save_pagelist
    }
    # Remove the lockfile
    fax_exec "rm -f $fax(lockfile)"
    exit
}

proc fax_guide {} {
#
# Text widget containing user guide of TkFax.
#
    global fax m
    fax_help  $m(guide) $fax(guide)

if { 0 } {
    set wn $fax(mwn).guide
    if [winfo exists $wn] return
    toplevel $wn
    wm title $wn "$fax(progname): $m(guide)"

    frame $wn.b
    pack $wn.b -side top -fill x
    label $wn.b.1 -text "$fax(progname) $m(guide)" -width 15
    button $wn.b.2 -text $m(close) -command "destroy $wn"
    pack $wn.b.1 $wn.b.2 -side left
    frame $wn.u
    pack $wn.u -side top -fill both -expand yes
    text $wn.u.t -width 80 -height 20 -font $fax(f1) \
                     -yscrollcommand "$wn.u.s set"
    mscroll $wn.u.t
    scrollbar $wn.u.s -command "$wn.u.t yview" -orient vertical
    grid  $wn.u.t $wn.u.s -sticky news
    grid  rowconfigure    $wn.u 0 -weight 1
    grid  columnconfigure $wn.u 0 -weight 1
    $wn.u.t insert end $fax(guide)
    $wn.u.t configure -state disabled
}
 }

proc fax_help { title_strings help_strings } {
# 11 Sep 2001 M.Shinomiya
    global fax m
    set wn $fax(mwn).help
    if [winfo exists $wn] return
    toplevel $wn
    wm title $wn "$fax(progname): $title_strings"

    text $wn.t -width 80 -height 20 -font $fax(f1) \
                     -yscrollcommand "$wn.s set"
    $wn.t insert end $help_strings
    $wn.t configure -state disabled

    mscroll $wn.t
    scrollbar $wn.s -command "$wn.t yview" -orient vertical

    button $wn.b -text $m(close) -command "destroy $wn"
    pack  $wn.b

    grid  $wn.t -column 0 -row 0 -sticky news
    grid  $wn.s -column 1 -row 0 -sticky news
    grid  $wn.b -columnspan 2 -row 1
    grid  rowconfigure    $wn 0 -weight 1
    grid  columnconfigure $wn 0 -weight 1
}

proc fax_message { text } {
#
# Display message.
#
    global fax
    $fax(messagewin) configure -text $text
    update
}

proc fax_print_fax { g3file } {
# 8 Sep trap if printcmd is not defined
# 2 Sep try to keep original size and retio
# 23 Aug 2001 Masaki Shinomiya
# Print a g3 format fax file.
#
    global fax m
    if { $fax(printcmd) == "" } {
         set msg "$m(printcmd) $m(does_not_exits) $m(edit_config)"
         fax_message $msg
         return 1
    }
    # resolusions
    foreach i {X Y} {
        set faxFrame($i) $fax(fax${i}dots)
        set frame($i) $fax(printer${i}dots)
        set sendReso($i) $fax(fax${i}reso)
        set reso($i) $fax(printer${i}reso)
    }
    if { $sendReso(Y) < 140 } {
        set normReso(Y) $sendReso(Y)
        set fineReso(Y)   [expr 2*$sendReso(Y)]
    } else {
        set normReso(Y) [expr 0.5*$sendReso(Y)]
        set fineReso(Y)   $sendReso(Y)
    }

    # maesure the image size
    set XY [get_image_size $g3file ]
    set org(X) [lindex $XY 0]
    set org(Y) [lindex $XY 1]
    if $fax(debug) {
         tk_messageBox -message "$X x $Y" -icon info -type ok
    }
    if { $org(X) <=0 } {return 1}

    # norm or fine
    set prefix [ get_prefix $g3file ]
    set header [ string range $prefix 0 1 ]
    switch $header {
        ff {  set norm 0 }
        fn { set norm 1 }
        default {
            if { $org(X) > 0.7*$faxFrame(X) && $org(Y) < $faxFrame(X) } {
                       set  norm 1
            } else { set  norm 0 }
        }
    }
    set orgReso(X) $sendReso(X)
    if $norm {  set orgReso(Y) $normReso(Y) } else {
                   set orgReso(Y) $fineReso(Y)
    }

    # determin the print size in dots
    set new(X)  [expr int(($org(X)*$reso(X))/$orgReso(X)+0.5)]
    set new(Y)  [expr int(($org(Y)*$reso(Y))/$orgReso(Y)+0.5)]
    set aspect [expr $new(Y)/$new(X).0]
    if { $new(X) > $frame(X) } {
        set new(X) $frame(X)
        set new(Y) [expr int($new(X)*$aspect+0.5)]
    }
    if { $new(Y) > $frame(Y) } {
        set new(Y) $frame(Y)
        set new(X) [expr int($new(Y)/$aspect+0.5)]
    }
# tk_messageBox -message "Oriigin size: $org(X)X$org(Y)\nResolusion: $orgReso(X)x$orgReso(Y)\nNew size: $new(X)x$new(Y)\nNew resolusion: $reso(X)x$reso(Y)" -icon -nfo -type ok

   # select command
   # 8 Sep 2001
   switch $fax(printertype) {
        lj {set command "$fax(g32pbm) -l $g3file | $fax(printcmd)"}
        ljs {set command "$fax(g32pbm) $g3file  2>>$fax(tkfaxlogfile) | \
             pnmscale -xsize $new(X) -ysize $new(Y) 2>>$fax(tkfaxlogfile) |\
             pgmtopbm -threshold | \
             pbmtolj -resolution $freso(X) | $fax(printcmd)"}
        efax -
        ps -
        default {
            if { $fax(printertype) != "ps" && $fax(faxagent) == "efax" } {
                set command "PRCMD=$fax(printcmd) fax print  $g3file"
            } else {  
             set command "$fax(g32pbm) $g3file 2>>$fax(tkfaxlogfile) | \
                 pnmscale -xsize $new(X) -ysize $new(Y) \
                 2>>$fax(tkfaxlogfile) | pgmtopbm -threshold |  pbmtolps -dpi $reso(X) |\
                 $fax(printcmd)"
            }
         }
          
    }
    set code [fax_exec_flag $command]
    return $code
}

proc fax_read_userconfig {} {
#
# Read a user configuration file
#
    global fax env
    if [file exist $fax(userconfigfile)] {
        source $fax(userconfigfile)
    }
}

proc fax_tex_char { string } {
#
# Convert a string to tex format.
#
#  2001/06/29  modified by R.Kawagishi
#
    global fax
# 1 Sep 2001 Do nothing if TeX not available
if { $fax(latex) == "" } { return $string }
if { $fax(latex) == "none" } { return $string }

    set converted ""
    for {set i 0} {$i < [string length $string]} {incr i} {
        set c [string index $string $i]
        case $c {
            <   {append converted "\\textless "}
            >   {append converted "\\textgreater "}
            \#  {append converted "\\#"}
            \$  {append converted "\\$"}
            %   {append converted "\\%"}
            &   {append converted "\\&"}
            _   {append converted "\\_"}
            \{  {append converted "\\\{"}
            \}  {append converted "\\\}"}
            |   {append converted "\\textbar "}
            ~   {append converted "\\textasciitilde "}
            ^   {append converted "\\textasciicircum "}
              {append converted "=\\llap{Y}"}
            \\  {append converted "\\textbackslash "}
            \\n {append converted "\\\\"}
            default {append converted $c}
        }
    }
    return $converted
}

# 15 Jan 2002 Masaki Shinomiya
proc num_encode { string } {
   set converted ""
    for {set i 0} {$i < [string length $string]} {incr i} {
        set c [string index $string $i]
        if { $c != " " } {
            case $c {
              \#  {append converted "_043"}
              [*]  {append converted "_052"}
              [.] {append converted "-"}
              default {append converted $c}
            }
        }
    }
    return $converted
}
proc num_decode { string } {
   set converted ""
   set i 0; while {$i < [string length $string]} {
        set w [string range $string $i [expr $i+3]]
        case $w {
            "_043"   {append converted "#"; set i [expr $i+4]} 
            "_052"   {append converted "*"; set i [expr $i+4]} 
            "_43*"   {append converted "#"; set i [expr $i+3]} 
            "_52*"   {append converted "*"; set i [expr $i+3]} 
           default {append converted [string index $string $i]; incr i}
        }
    }
    return $converted
}

proc fax_userdir_check {} {
#
# Check if $fax(userdir) exists. If not, creates it properly.
#
    global fax
    if [file exist $fax(userdir)] {
        if [file isdirectory $fax(userdir)] {
            foreach dir {texdir pbookdir tmpdir} {
                if [file exist $fax($dir)] {
                    if [file isdirectory $fax($dir)] {
                    } else {
                        puts "$fax($dir) exists, but not a directory."
                    }
                } else {
                    exec mkdir $fax($dir)
                }
            }
        } else {
            puts "$fax(userdir) exists, but not a directory."
        }
    } else {
        foreach dir {userdir texdir pbookdir tmpdir} {
            exec mkdir $fax($dir)
        }
        exec echo -e "Misc\tMiscellaneous fax numbers" \
                  > $fax(pbookdir)/group.pbd
        exec touch $fax(pbookdir)/Misc.pbd
    }
}

proc fax_view_fax { files } {
#
# Launch a viewser for fax files in g3 format.
#
# 4 Sep 2001 set default viewer
    global fax
    if { $fax(viewer) == "" } {
        if { $fax(faxagent) == "efax" } {
            set viewer "fax view"
        } else {
            set viewer "viewfax"
        }
    } else {
        set viewer "$fax(viewer)"
    }
# tk_messageBox -message "$viewer $files" -icon info  -type ok
    fax_exec_bg "$viewer $files"
}

proc get_prefix { fn } {
#
# Return prefix from a filename.
#
    set p [string last / $fn]
    set q [string last . $fn]
    if {$p < $q} {
        set prefix [string range $fn [expr $p+1] [expr $q-1]]
    } else {
        set prefix [string range $fn [expr $p+1] end]
    }
    return $prefix
}

proc get_image_size { fn } {
#
# maesure the image size
# calling procedure::
#     set XY [get_image_size $fn ]
#     set X [lindex $XY 0]
#     set Y [lindex $XY 1]

# 2 Sep 2001 by Masaki Shinomiya

    global fax m
    set id [fax_exec "identify $fn"]
#  tk_messageBox -message "$id" -icon info -type ok
    set xpos -1
    set n 0
    foreach i $id {
        if  { $n > 0 } {
          if { [set xpos [string first "x" $i]] > 0 } { break }
        }
        set n [expr $n+1]
    }
    set org(X) 0
    set org(Y) 0
    if { $xpos > 0 } {
        set org(X) [string range $i 0 [expr $xpos-1]]
        set org(Y) [string range $i [expr $xpos+1] end ]
        set ypos [string first "+" $org(Y)]
        if { $ypos > 0 } { set org(Y) [string range $org(Y) 0 [expr $ypos-1]] }
    }
    if { $org(X) <= 0 || $org(Y) <= 0 } {
#       tk_messageBox -message "Could not identify\n$id ?" -icon error -type ok
       fax_error "get_image_size: Could not identify\n$id ?"
       return { -1 -1 }
    }
    if $fax(debug) {
       tk_messageBox -message "$id\n$i\n$org(X)\n$org(Y)" -icon info  -type ok
    }
    set result {}
    lappend result  $org(X) 
    lappend result  $org(Y)
    return $result
}

# test if the shell command is excutable or not
# 26 Sep 2001 by Masaki Shinomiya
proc excutable { cmd } {
    global fax m
    if { $cmd == "" } { return 1 }
    set c [lindex [split $cmd " "] 0]
    set code [catch { set result [exec sh -c "which $c"]}]
    if { $code == 0 } { return 1 }
    return 0
}
