# This file is a part of TkFax.
# fax-logbrowser.tcl
# 23 Jan 2002 Masaki Shinomiya

proc fax_log_browse {} {
    global fax m

    # The name of the window
    set w $fax(mwn).logedit
    if [winfo exists $w] {return}
    toplevel $w
    set m(procname) "Log browser"
    fax_message ""
      wm title $w "TkFax: $m(procname)"
#    wm minsize $w 320 380

    set wp $w.p
    frame $wp

    #Buttons
    frame $wp.a
    pack $wp.a -side  bottom -fill x -expand no
    button $wp.a.1 -text $m(view) -command fax_viewdir  -pady 5
    button $wp.a.2 -text $m(save) -command fax_save_log   -pady 5
    button $wp.a.3 -text $m(delete) -command fax_delete_log   -pady 5
    button $wp.a.0 -text $m(close)  -command "destroy $w"    -pady 5
    pack $wp.a.0  -side right -fill x -expand yes
    pack $wp.a.1 $wp.a.2 $wp.a.3  -side left -fill x -expand yes

    #Panel
    set wn $wp.b
    frame $wn
    pack $wn -side top -fill both -expand yes
   
    label $wn.1 -text "TkFax: $m(procname)" -pady 4 -relief ridge
    label $wn.2 -text $m(directory) -anchor w
#    checkbutton $wn.t -text $m(show_hidden) -variable fax(lookupall) \
#                -anchor w
    button $wn.u -text $m(update) -width 20 -command fax_update_loglist
    entry $wn.3  -textvariable fax(logcurdir) -font $fax(f1) -fg $fax(c1)
    label $wn.4 -text $m(files)  -anchor w
    label $wn.5 -text ""  -anchor w -fg red
    listbox $wn.6 -width 40 -height 8 -font $fax(f1) \
            -yscrollcommand "$wn.7 set" -xscrollcommand "$wn.8 set"
    mscroll $wn.6
    scrollbar $wn.7 -orient vertical   -command "$wn.6 yview"
    scrollbar $wn.8 -orient horizontal -command "$wn.6 xview"
    label $wn.9 -text "" -padx 7 -pady 0 -relief sunken

    grid $wn.1 -row 1 -column 0 -rowspan 1 -columnspan 4 -sticky news -pady 5
    grid $wn.2 -row 2 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.u -row 2 -column 2 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.3 -row 3 -column 0 -rowspan 1 -columnspan 4 -sticky news
    grid $wn.4 -row 4 -column 0 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.5 -row 4 -column 2 -rowspan 1 -columnspan 2 -sticky news
    grid $wn.6 -row 5 -column 0 -rowspan 1 -columnspan 3 -sticky news
    grid $wn.7 -row 5 -column 3 -rowspan 1 -columnspan 1 -sticky news
    grid $wn.8 -row 6 -column 0 -rowspan 1 -columnspan 3 -sticky news
    grid $wn.9 -row 6 -column 3 -rowspan 1 -columnspan 1 -sticky news
#    grid $wn.a -row 7 -column 0 -rowspan 1 -columnspan 4 -sticky news -pady 5

    grid  columnconfigure $wn 0 -weight 1
    grid  rowconfigure    $wn 5 -weight 1

    # Text browser
    set wt $w.text
    frame $wt
    label $wt.title  -text "" -font $fax(f1) -fg $fax(c1)
    text $wt.text -width 40 -font $fax(f1) \
            -yscrollcommand "$wt.y set"
    mscroll $wt.text
    scrollbar $wt.y -orient vertical   -command "$wt.text yview"
    pack $wt.title -side top -fill x -expand no
    pack $wt.y -side right -fill y -expand no
    pack $wt.text -side right -fill both -expand yes
    
    pack $wp -side left -fill y -expand no
    pack $wt -side left -fill both -expand yes

    # Globally used widgets
    set fax(logmsg) $wn.5
    set fax(loglist)  $wn.6
    set fax(logtitle) $wt.title
    set fax(logtext) $wt.text

    # Keyboard and mouse bindings
    bind $wn.3 <KeyPress-Return> { 
        set fax(logcurdir) $fax(startlogdir) ; fax_update_loglist
    }
#    bind $wn.6 <Button-1> fax_viewlog
    bind $wn.6 <Double-Button-1> fax_viewdir

    # Initialization
    set fax(logcurdir) $fax(startlogdir)
    fax_update_loglist
}

proc fax_update_loglist {} {
#
# Fills the filelist from the current directory.
# 31 Aug 2001 swicth showing hidden files
    global fax m
    set curdir $fax(logcurdir)
    set lookupall 1

    if {$lookupall} { set option "-a" } else { set option "" } 
     set dirs [fax_exec "ls -l $option $curdir"]
     set dirs [split $dirs "\n"]

    $fax(loglist) delete 0 end
    if { ! $lookupall } {
          $fax(loglist) insert end [format "%-12s  %-22s" $m(directory) ".."]
    }
     foreach line $dirs {
        set name  [lindex $line 8]
        if { $name != "" } {
          set fname "$curdir/$name"
          if {[file isdirectory $fname] && $name != "." } {
            if { $name == ".." } { set name "$m(parent)" }
            $fax(loglist) insert end [format "%-12s  %-22s" $m(directory) $name]
          }
        }
     }

     set dirs [fax_exec "ls -lt $option $curdir"]
     set dirs [split $dirs "\n"]
     set focus -1

     foreach line $dirs {
        set time [format "%3s %2s %5s" \
            [lindex $line 5] [lindex $line 6] [lindex $line 7]]
        set name  [lindex $line 8]
        if { $name != "" } {
            set fname "$curdir/$name"
            if { [file isfile $fname] } {
                if { $focus < 0 } {
                    if { [viewtext_quiet $fname]==0 } {
                        set focus [$fax(loglist) size]
                    }
                }
                $fax(loglist) insert end [format "%-12s  %-22s" $time $name]
            }
        }
     }

#     $fax(loglist) select clear
     if { $focus >= 0 } {
         $fax(loglist) select set $focus $focus
         $fax(loglist) see $focus
     } else {
        viewtext ""
     }
     return
}

proc fax_logselect {} {
    global fax m
    # When no file is selected, return null.
    if {[$fax(loglist) curselection]=={}} { return {} }
    # Get filename and test if it is a directory or a file.
    # If directory, list the files in that directory and return.
    return [selection get]
}

proc fax_viewdir {} {
    global fax m
    set curdir $fax(logcurdir)
    set t [fax_logselect]
    if { $t == {} } { return }
    set f [lindex $t 3]
    if { $f == "" } { set f [lindex $t 1] }
    if {$f=="$m(parent)"} { set f ".." }
    if [file isdirectory $curdir/$f] {
        set xx [expr [string last / $curdir]-1]
        if {$f==".."} {
            if {$xx < 0} { set curdir "/"
            } else { set curdir [string range $curdir 0 $xx] }
        } else {
            if {$curdir=="/"} { set curdir "/$f"
            } else { set curdir "$curdir/$f" }
        }
        set fax(logcurdir) $curdir
        fax_update_loglist
        return
    }
    fax_viewlog
}

proc fax_viewlog {} {
    global fax m
    set curdir $fax(logcurdir)
    set t [fax_logselect]
    if { $t == {} } { return }
    set f [lindex $t 3]
    set fname $curdir/$f
    if [file isdirectory $fname] { return }
    viewtext $fname
}

proc viewtext_quiet  { fname } {
    set filetest [fax_exec "file $fname"]
    if { [string first {text}    $filetest ]  < 0 } { return 1 }
    return [viewtext $fname]
}

proc viewtext { fname } {
    global fax m

    if { $fname == "" } {
    $fax(logtext) configure -state normal
    $fax(logtext) delete 1.0 end
    $fax(logtext) configure -state disabled
    $fax(logtitle) configure -text ""
    update
    return 0
    }

    if [file_exist_check $fname] { return 1 }
    set filetest [fax_exec "file $fname"]
    if { [string first {text}    $filetest ]  < 0 } { 
            set q [tk_dialog .dialog "TkFax Dialog" \
                   "$fname seems to be a non-text file. " {error} 0 $m(ok)]
        return 1
    }
    $fax(logtext) configure -state normal
            set fid [open $fname r]
            $fax(logtext) delete 1.0 end
            while {[gets $fid line]>=0} {
                 $fax(logtext) insert end "$line\n"
            }               
            close $fid
    $fax(logtext) configure -state disabled
    $fax(logtitle) configure -text [file tail $fname]
    update
    return 0
}

proc fax_save_log {} {
    global fax m curdir
    set m(procname) $m(save)
    fax_log_message ""
    set curdir $fax(logcurdir)

#    set ext ".log"
    if {[$fax(loglist) curselection]=={}} { return }
    set f [lindex [selection get] 3]
    if [file isdirectory $curdir/$f] { return }
    set forg $curdir/$f
        set ftypes {
            { "Log files" .log }
            { "All types" * }
        }
        set fname [tk_getSaveFile -initialdir $fax(userdir) -filetypes $ftypes \
                  -parent . -initialfile $f -defaultextension .log ]
        if { $fname == "" } {
            return
        } else {
            fax_exec "cp $forg $fname"
            fax_log_message "$f was saved as $fname."
        }
}

proc fax_delete_log {} {
    global fax m
    set m(procname) $m(delete)
    fax_log_message ""
    set curdir $fax(logcurdir)

    set ext .log
    if {[$fax(loglist) curselection]=={}} { return }
    set f [lindex [selection get] 3]
    set fname $curdir/$f
    if [file isdirectory $fname] { return }
    set k [tk_dialog .dialog "TkFax Log Delete" \
        "$m(delete) $f?" {warning} 1 $m(confirm) $m(cancel)]
    if {$k} { return }
    if [fax_exec_flag "rm -f $fname"] { return }

     fax_update_loglist
     fax_log_message "$f $m(deleted)"
}

proc fax_log_message { msg } {
}