# This file is a part of TkFax.
#

#
# This procedure calls TkScan window.

proc fax_scan_window {} {
    global fax c s w l file

    fax_message ""
    set s(unit) mm
    set s(premodecurrent) 0

    # The user configuration file, if exists, overwrites the above assignments.

    if [file exists $c(userconf)] {source $c(userconf)}

    # Initialization of some variables

    set s(nrect)    0
    set s(runscan)  0
    set s(curscan)  0
    set s(stop)     0

    # This is for directing output to fax
    set c(autofaxif) 1

    # Launch main window

    toplevel .s
    wm title .s "TkFax+TkScan"
    Window_Scan .s
    Preview_Canvas
    image create photo preview -data {}
    set ip [expr $s(o)-1]
    $w(prev) create image $ip $ip -image preview -anchor nw
    set s(rect0) [$w(prev) create rectangle 0 0 0 0 -width 1 -outline $l(c2)]
    settop $s(o) $s(o)
    setbottom $s(maxpwidth) $s(maxpheight)
    setunit $s(unit)
    setmode $s(mode)
    .s.menu.l configure -text "TkScan $c(version): Fax Scan"
    stat_text "TkScan $c(version)"

    setquickmode Fax
    setquickpaper A4
}

