# This file is a part of TkFax.
# Massages 'C' as defalt (in English)
# 2 Nov 2001

foreach i {progname date ex_version ex_date} {
   if ![info exists fax($i)] {set fax($i) ""}
}

# Fax

set m(is_not_available) "not available"

# menu
set m(new_session) "New"
set m(quit) "Quit"
set m(config) "Config"
set m(edit_config_file) "Edit configuration..."
set m(logs) "Logs"
set m(lookup_logs) "Look up logs"
set m(help) "Help"
set m(about) "About.."
set m(guide) "Guide"

# frames
set m(page_list) "Page List"
set m(page_manipulation) "Page Manipulation"
set m(dialing_and_queuing) "Dialing & Queuing"
set m(number) "Number"
set m(recipient) "Recipient"
set m(message) "Message:"

# buttons
set m(custom) "Cover"
set m(file) "File"
set m(scan) "Scan"
set m(up) "Up"
set m(down) "Down"
set m(view) "View"
set m(view_all) "View All"
set m(save) "Save"
set m(save_all) "Save All"
set m(print) "Print"
set m(print_all) "Print All"
set m(delete) "Delete"
set m(delete_all) "Delete All"
set m(clear) "Clear"
set m(regist) "Regist"
set m(phone_book) "Phone Book"

set m(fax_received) "Fax Received"
set m(fax_spool) "Fax Spool"
set m(spooling) "Spooling"
set m(fax_outgoing) "Fax Outgoing"
set m(receive) "RECEIVE"
set m(send) "SEND"

# file
set m(attach) "Attach"
set m(file_type) "File Type"
set m(ok) "OK"
set m(yes) "Yes"
set m(no) "No"
set m(cancel) "Cancel"
set m(confirm) "Confirm"
set m(unkown_filetype) ": unkown filetyle"
set m(attached) ": attached"
set m(converting) "Converting..."
set m(show_hidden) "Show all"
set m(dithering_method) "Quality"
set m(photo) "Photo"
set m(halftone)   "Halftone"
set m(linart)  "Linart"
set m(parent) "(parent)"

# Page manipulation
set m(no_pages_selected) "Select page(s) first."
# Print
set m(sent_to_printer) " was sent to printer."
set m(all_sent_to_printer) "All pages were sent to printer."
# Save
set m(save_all_fax_pages_with_prefix) "Save all fax pages with prefix"
set m(was_saved_as) " was saved as "
set m(all_pages_were_saved_as) "All pages were saved as "

# Delete page
set m(delete_a_page) "Delete a page"
set m(delete_all_pages) "Delete all pages"
set m(deleted) " deleted."
set m(all_pages) "All pages"
set m(delete_the_fax) "Delete the fax"
set m(delete_all_fax) "Delete all faxes"

# confirmation
set m(odd_number_coverpage) "Cover page file(s)\${files} of odd fax number exists."
set m(multiple_cover) "Multiple cover pages\${files} found."
set m(not_at_the_top) "Cover page file(s)\${files} not at the top."
set m(is_it_ok) "Is it OK?"
set m(an_error_occured) "An error occured.\nLook up te log?"
set m(multi_run) "You seem to run multiple $fax(progname). Continue anyway?"

# make cover
set m(cover) "Cover page"
set m(will_you_use_it_or_make_new_one) "Will you use it or make new one?"
set m(make_new_one) "Make new one"
set m(use_exsiting_one) "Use exsiting one"
set m(mkpg) "Making Fax cover page"
set m(insert_date) "insert Date"
set m(insert_time) "Insert Time"
set m(insert_phrase) "Insert Phrase"
set m(finish) "Complete"
set m(insert_file) "Insert text form a file"
set m(load_all_item) "Load all items from a file"
set m(save_all_item) "Save all items to a file"
set m(save_header) "Save header"
set m(new_cover) "New"
set m(phrase) "Phrase"
set m(char_size) "Char.size"
set m(points) "pnts"
set m(header) "Header"
set m(cfax_number) "Fax Number"
set m(crecipient) "Recipient"
set m(creference) "Organization"
set m(cdate) "Date"
set m(cfrom) "From"
set m(ctitle) "Title"
set m(contents) "Contents"
set m(all_types) "Any type"
set m(test) "Text"
set m(c_lang) "C source"
set m(header_file) "Header file"
set m(html) "Hyper text"
set m(tkfax_fax_cover) "tkfax cover file"
set m(abandon_cover) "$m(ctitle) and $m(contents) will be abandoned."

# edit configure
set m(load_default) "Load default"
set m(abandon_config) "All settings will be abandoned and load defalts."
set m(extprogs) "Ext. Progs"
set m(looks) "Appearance"
set m(letter_head) "Letter Haed"
set m(repetitives) "Repetitives"
set m(user) "User's"
set m(tmp) "Temporary"
set m(pbook) "$m(phone_book)"
set m(tex)   "User's TeX"
set m(systex) "System TeX"
set m(spool) "Spool"
set m(incoming) "$m(fax_received)"
set m(outgoing) "$m(fax_outgoing)"
set m(log) "Logging"
set m(auto) "Auto"
set m(none) "Not use"
set m(config_file_updated) \
    "Configuration file updated. Restart Tkfax to enable changes."
set m(edit_config) "Edit configuration first!"
set m(new_config) "New config file is created."
set m(old_config) "Old version of config file is found."

set m(locale) "Locale"
set m(usrlocale) "Locale"
set m(faxagent) "Fax agent"
set m(viewer) "Fax viewer"
set m(xterm) "Terminal"
set m(mpage) "Text to Postscript"
set m(printcmd) "Print command"
set m(printertype) "Printer type"
set m(others) "Others"
set m(faxPaper) "Fax paper"
set m(printerPaper) "Printer paper"
set m(Xmargin)  "Left margin"
set m(Ymargin)  "Upper margin"
set m(Xreso)     "Resolution" 
set m(atexit) "Workspace"
set m(cleartmpdiratexit) "Clear tempdir on exit"

set m(font) "Font"
set m(button) "button "
set m(text) "text "
set m(window) "window "
set m(background) "background "
set m(forground) "forground "
set m(active) "active "
set m(select) "selected "
set m(color) "color"
set m(select_color) "Select color..."


# library
set m(no_page_to_send) "No page to send"
set m(fax_number_is_empty) "Fax number is empty."
set m(fax_to_spooler) "pages are sent to spooler"
set m(log_is_left_in) "Log is left in"
set m(successfully_sent) "Successfully sent."
set m(successfully_received) "Successfully received."

# Phone Book
set m(tkfax_fax_number_book) "TkFax: Fax Number Book"
set m(group) "Group"
set m(group_name) "Group Name"
set m(description) "Description"
set m(add) "Add"
set m(remove) "Remove"
set m(fax_number) "Fax Number"
set m(reference) "Organization"
set m(replace) "Replace"
set m(sort) "Sort"
set m(select_fax_number) "Select Fax Number"
set m(close) "Close"
set m(does_not_exist) "does not exist."
set m(is_reserved) "is reserved."
set m(is_already_used) "is already used."
set m(phone_book_database_file) "Phone book database file"
set m(is_already_exists)  "is already exists."
set m(do_you_want_to_read_it_in) "Do you want to read it in?" 
set m(cannot_be_removed) "cannot be removed."
set m(do_you_want_to_delete_a_phone_book_database_file) "Do you want to delete a phone book database file"
set m(enter_fax_number) "Enter fax number."
set m(is_registered_in) "is registered in"
set m(select_group_other_than_all) "Select group other than 'All'."
set m(no_fax_number_selected) "No fax number selected."

# fax received
set m(received_fax_list) "Received Fax List"
set m(collect_pages) "Collect Pages"
set m(time) "Time"
set m(from) "From"
set m(pages) "Pages"
set m(selected_files) "Selected File(s)"
# delete
set m(delete_the_fax) {Delete the fax}
set m(delete_a_job) "Delete a job"

# fax queue
set m(unable_function) "This function is unavalable."
set m(job_list) "Job List:"
set m(wating) "Wating"
set m(old) "Old"
set m(susp) "Susp"
set m(sec) "sec"
set m(update_every) "Update every"
set m(rank) "Rank"
set m(owner_id) "Owner/ID"
set m(class) "Class"
set m(job_id) "Job ID"
set m(size) "Size"
set m(time) "Time"
set m(status) "Status"
set m(queued_by) "Queued by"
set m(history) "History"
set m(all) "All"
set m(to) "To"

set m(hit_return_to_finish) "Hit Return to finish ..."

###
# Scan

# menu
set m(default) "Default"
set m(set_current_as_default) "Set current as Default"
set m(save_current_config) "Save current config"
set m(quick) "Quick"
set m(copy_machine_gray) "Copy Machine (Gray)"
set m(copy_machine_color) "Copy Machine (Color)"
set m(fax_scan) "Fax Scan"
set m(scanner_default) "Scanner Default"
set m(mode) "Mode"
set m(graycopy) "GrayCopy"
set m(colorcopy) "ColorCopy"
set m(fax) "Fax"
set m(ocr) "OCR"

# main panel
set m(output_to) "Output to"
set m(lineart) "Lineart"
set m(halftone) "Halftone"
set m(gray) "Gray"
set m(color) "Color"
set m(resolution) "Resolution"
set m(geometry) "Geometry"
set m(length_unit) "Length Unit"
set m(preset) "Preset"
set m(clean) "Clean"
set m(fine_tune) "Fine Tune"
set m(real_size) "Real Size"
set m(screen_size) "Screen Size"
set m(data_size) "Data Size"
set m(preview) "Preview"
set m(stop) "Stop"

# file manager
set m(file_manager)  "File Manager"
set m(directory) "Directory"
set m(mkdir) "mkdir"
set m(image_files_only) "Image Files Only"
set m(update) "update"
set m(convert) "Convert"
set m(rename) "Rename"
set m(view_with) "View with"
set m(convert_to) "Convert to"
set m(print_to) "Print to"
set m(zoom) "Zoom"
set m(x) "X"
set m(y) "Y"
set m(automatic_output_processing) "Automatic Output Processing"
set m(files) "Files"
set m(bar) "| "

# option manager
set m(option) "Option"
set m(option_manager) "Option Manager"

# preference manager
set m(preference) "Preference"
set m(preference_manager) "Preference Manager"
set m(scan_command) "Scan Command"
set m(scan_device) "Scan Device"
set m(preview_mode) "Preview Mode"
set m(apply) "Apply"
set m(print_command) "Print"
set m(printer_paper) "Printer Paper"
set m(tmp_directory) "TMP Directory"
set m(clear_when_exit) "Clear when Exit"
set m(clear_now) "Clear Now"


#
# User Guide

set fax(guide) "
$fax(progname)  $fax(ex_version) - A Tcl/Tk GUI for using facsimile
                (c) 2001 Masaki Shinomiya <shino@pos.to>
                             Ryoji Kawagishi  <kawagisi@yk.rim.or.jp>
TkFax 0.91 (c) 1998 Hang Bae Kim <hbkim@muon.kaist.ac.kr>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
   See the GNU General Public License for more details.

Contents
     1. Making fax pages
     2. Sending fax
     3. Using the $m(phone_book)
     4. Queuing outgoing faxes
     5. Recieving fax
     6. Looking up faxes
     7. About this version
     8. Bug and report

================================================================
 1. Making fax pages
================================================================
    The procedure will be:
        (1) Input the recepient
        (2) Making the cover page
        (3) Making pages from text or image files
        (4) Using a scanner
        (5) Preparing and checking pages

    (1) Input the recepient
       Input the fax $m(number) and $m(recipient).
       See the later how to use the $m(phone_book).

    (2) Making the cover page
       Select the tenplate from 'English', 'Japanese'(*), 'Aux'(*).
       This button places at the top right in the $m(page_manipulation) group.
       Then, click '$m(custom)'.  $m(mkpg) window will appear.
       See the $m(help) in the $m(mkpg) window. Edit the entries.
       Click '$m(finish)'. The cover page will be automatically created. 
       After a few second, you can find the name such as 'cvr01234.001.g3'
       in the $m(page_list).
       You can check the page by double clicking this name or use '$m(view)'.

       *) You can use 'Japanese' only when your system can treat Japanese.
       *) Prepare the TeX macro for 'Aux' by name 'covermacro-aux.tex'
       at the directory, usually at '$fax(systexdir)'(system)
       or at '$fax(texdir)'(user).

       If you are familiar with TeX, you can customize the file 'covermacro-??.tex'
       at the system directory, usually at  '$fax(systexdir)'
       or copy it in the user directory, '$fax(texdir)'.

    (3) Making pages from text or image files
       Click '$m(file)', select the file you want to attach. Sometime you must
       also select the type of the file.
       You can select multiple files at a time. Try dragging, Shift-key+clicking,
       Ctrl-key+clicking, and see how the actions effect.
       Click '$m(attach)'. The page will be created and add on the $m(page_list).

    (4) Using a scanner
       Click '$m(scan)'. The TkScan window will appear.
       See  the $m(help) in the TkScan window. 
       
    (5) Preparing and checking pages
       Select the file name in the $m(page_list) and click '$m(view)', 
       the fax viewer will be launched. Or simply double-click the file name.
       Click '$m(view_all)' to see all the pages listed in the $m(page_list)
      if your viewer supports this function.  Kfax supports '$m(view_all)'.

       Check the page order. Use $m(up) and $m(down) to change the order.
       You can '$m(delete)' pages you do not want to send.

==================================================================
 2. Sending fax
==================================================================

    (1) Fill the fax '$m(number)' and the '$m(recipient)' at $m(dialing_and_queuing).
    (2) You can '$m(regist)' the '$m(number)' and the '$m(recipient)' 
       to be registered in the $m(phone_book) for the later use.
    (3) Click '$m(send)' to send the fax pages on the $m(page_list).

    If you have a phone connected with the modem and use the phone in dialing,
    skip the process (1)to(2). Confirm the receiver ready and just click '$m(send)'.
    Then put down the handset.

    If you have already recieved a call by the phone and the line connected, 
    you can click '$m(send)' to send fax. Put down the handset.

    If you check the '$m(fax_spool)' box on, the fax data will be handed to
    the spooler and sent in the background. You can check the status with
    looking up the '$m(fax_outgoing)'.

    If you like to use '$m(fax_spool)' function with efax, you need
    efax-0.9a001114a6 or later, and to see the documents.

==================================================================
 3. Using the $m(phone_book)
==================================================================

    Click '$m(phone_book)' on the TkFax main window. The $m(phone_book)
    window will appear.

    (1) Making a new $m(group)
      Fill the '$m(group_name)' entry by the name of the new $m(group).
      Use the '$m(description)' entry to describe the summary of the $m(group).
      Click '$m(add)', then the new $m(group) added on the $m(group) list.

    (2) Add a new address
      Fill the entries, '$m(fax_number)','$m(recipient)','$m(reference)','$m(description)',
      on the lower part of the window.
      Select the $m(group),  which the new address to be the member of
      from the upper part of the window. The $m(group) '$m(all)' is the exception.
      Click  '$m(add)' on the lower part of the window.

      From the main panel, click '$m(regist)' to register the $m(number) and $m(recipient).
      This entry is add in the 'Misc' $m(group).

    (3) Use a registered address
      Select the $m(group) from the $m(group) list on the upper part of the window.
      When $m(all) is selected, all address of all $m(group) is showed on the lower part.
      Select a $m(fax_number) in the list on the lower part, then the entry is showed
      in the lower columns.
      Click '$m(select_fax_number)', then the $m(fax_number) and the $m(recipient) are
      sent to the main panel. 
      If you have opened the $m(mkpg) window,  the $m(fax_number),
      $m(recipient), $m(reference) and $m(description) are sent to the $m(mkpg).

==================================================================
 4. Queuing outgoing faxes
==================================================================

      You need settings to work the spooling if you use 'efax' as the fax agent.
      See 'SENDING FAXES USING THE PRINT SPOOLER' section of 'man efax'.
      We recommend  'efax' with 'efax-spooling.patch'. Otherwise, $m(fax_received) 
      and $m(fax_outgoing) $m(directory) should be the same as the $m(fax) $m(directory).

      Check the $m(fax_spool) '$m(spooling)' to enable this function. In this mode,
      terminal window does not apear when you click '$m(send)' button. Faxes are
      put in the '$m(fax_outgoing)' box, and sent automatically by the background
      program. You need not wait until the sending action finished in this mode.

      Dialing is retried if the line was busy. The interval and how many times of
      retrying is set by /etc/efax.rc. A mail will be sent to the user when the sending
      job is completed and when failed after the max times of retry.

      Sending jobs in the queue can be look up by clicking the '$m(fax_outgoing)' button.
      Use '$m(delete)' button after selecting jobs to abort sending, .
      The '$m(fax_outgoing)' box can also manipulate any fax jobs using the print spooler
      other than by $fax(progname).  
      The headers in fax queue window does not properly indicate in case using efax.

      NOTE: Settings in ~/.efaxrc do not affect in this mode.
      
==================================================================
 5. Receiving fax mannually ( efax only )
==================================================================

      This function does not work with 'sendfax' as the fax agent.

      A phone to be connected with the modem.
     
      (1) Hook up with TkFax
        When you have a fax call and the bell of the phone ringing,
        Click '$m(receive)' on the main panel.
        The modem will hook up, receive the fax, and automatically hook down.

      (2) Hook up with the phone
        Ask the receiver to be ready. Confirm the tone of the fax machine.
        Click '$m(receive)' on the main panel.  Put down the handset.

      (3) Dial up and receive fax
        Dial up with the phone. Confirm the sender ready.
        Click '$m(receive)' on the main panel.  Put down the handset.

==================================================================
 6. Looking up faxes received
==================================================================

    Click '$m(fax_received)'. The $m(fax_received) window will appear.
    Select faxes from the $m(received_fax_list) and click the command.
    You can $m(view), $m(save), $m(print), $m(delete), or $m(attach).
    The '$m(attach)' command makes a copy of the fax page in the $m(page_list) 
    on the main panel so that you can pass this copy to another recipients.

==================================================================
 7. About this version
==================================================================

    $fax(progname)  $fax(version) is  written by Hang-Bae Kim as a Tcl/Tk GUI for sending and
    receiving faxes with mgetty+sendfax.

    $fax(progname)  $fax(ex_version) is to work with efax, that supports Class 1, 2 or 2.0 fax modems.
    This version can treat Japanese characters and  potentially allows any languages
    if you prepare the enviroments properly.
    GUI in this version is extended including making cover page and configuring the
    settings.
    Some new scanner drivers added in this version.
    Documantations prepared and maintained.

==================================================================
 8. Bugs and report
==================================================================

    Do not hesitate to contact us. Please e-mail to:  tkscanfax <shino@pos.to>
    The supporting page at the URL:   http://shino.pos.to/linux/tkscanfax.html

==================================================================

   History

        Oct 1998    version 0.91 by Hang Bae Kim <hbkim@muon.kaist.ac.kr>

        May   2001   I18N and efax extention project starts
        Jul   2001   version 0.99
        Aug   2001   version 0.99a
        Sep   2001   version 0.99b
        Sep   2001   version 0.99c
        Oct   2001   version 0.99d
        Jan   2002   version 0.99final
        Jan   2002   version 1.0

    TkScanFax extention project
        Masaki SHINOMIYA <shino@pos.to>
        Ryoji Kawagishi  <kawagisi@yk.rim.or.jp>

"

# 
# Help of Making cover page
#
set m(mkpghlp) "=== TkFax making cover page help

1. $m(header) 1-3
    Input your Corporate name, sections, address, tel/fax numbers, etc.
    These headers can be saved by slecting \[$m(file)\] - \[$m(save_header)\].

2. \[$m(file)\] \[$m(save_all_item)\]
    All items including headers for making cover pages will be saved. 
    The file name is automatically determined according year-day-time,
    such as '2001_1231_2359.cover' in the directory '~/.tkfax' .
    You can edit this file by text editors if you like. 

3. \[$m(file)\] \[$m(load_all_item)\]
    All items will be filled by the data form the '*.cover' file.

4. \[$m(insert_date)\] \[$m(insert_time)\]
     Today's date or the time now will be written at the current 
     cursor position. 

5. \[$m(insert_phrase)\]
     Selected phrase stated in the file  '~/.tkfax/conf.tcl', which
     can be edited by using \[$m(edit_config_file)\] form the main panel.
     Or, you can edit the file by text editors.

6. \[$m(from)\]
    This colomn is filled automatically by the data in '~/.tkfax/conf.tcl'.
    You can edit it here as temporal.
    The data in  '~/.tkfax/conf.tcl' can be edited by using \[$m(edit_config_file)\].
    Or, you can edit the file '~/.tkfax/conf.tcl' by text editors.

7. \[$m(contents)\]
    Chose \[Text\] in usual, and type the document.

8. Using TeX
    Chose \[TeX\], if you like the text to be compiled as a TeX document.
    You can use advanced layout, including tables and/or 'eps' figures.
"
set  m(texhlp) {
    Caution:
       Spaces are interpreted as one space in TeX.
       Carrige-return/line-feed is ignored in TeX document.
       Use '\\' to make new line in TeX.
       See the references of TeX for the detail.

9. Using LyX - GUI editor for TeX
    You can use 'LyX' - GUI for editing TeX document.
    After filling the items here, select 'TeX', and click [Finish].
    LyX will be launched.

    Edit the document by LyX.
    Expot it as LaTeX( [File] - [Export] - [as LaTeX] ).
    Quit LyX ( [file] - [Exit] ).

    The fax page will be automatically created and add on the 'Page list' 
    on the main panel. 
}

set   m(confighelp) "=== Tkfax configure help

    Click \[$m(close)\] after changes completed. 
    And \[$m(quit)\] from main panel.
    New settings will be enabel from next session of TkFax.
   
\[$m(directory) tab \]

    Set proper directories if your system requires.

\[$m(extprogs) tab\]

    \[$m(usrlocale)\]
        Auto : System default ( set by the environment variable LANG )
        Select below if the automatic detection does not work.
        C  : English                cs : Czech
        da : Danish                 de : German 
        en : English                eo : Esperanto 
        es : Spanish                fa : Persian
        fi : Finnish                fr : French
        ga : Irish                  hu : Hungarian
        id : Indonesian             it : Italian
        ja : Japanese               kr : Korean
        la : Latin                  no : Norwegian
        nl : Dutch                  pt : Portuguese
        pl : Polish                 ru : Russian
        sl : Slovenian              sv : Swedish
        tr : Turkish                zh : Chines

      *Only some languages are efective at this point of time.
       Your setting shall be ignored and treated as is 'C' (English)
       unless the language ready. 

    \[$m(faxagent)\]
      Select 'mgetty+sendfax' or 'efax' as the fax program.
      The 'mgetty+sendfax' is not fully tested with TkFax.
      We are calling for your report.

    \[$m(viewer)\]
       If you set $m(auto) here and your $m(faxagent) is efax, $m(viewer) is
       taken from the valuable VIEWCMD defined in the file /etc/efax.rc.

      Customize some other special commands used in TkFax.

    \[$m(mpage)\] is typically 'mpage -1 -o -m30l'.
     Or,'a2ps --columns=1 --borders no --margin=30 -R -B' if you use a2ps.
      See deatail on the man pages of 'mpage' or 'a2ps'.

    \[$m(faxPaper)\] the paper size which is assumed in fax page generation 
    \[$m(printerPaper)\] the paper size for local printing.
           A4     : 210 mm x 297 mm
           Letter : 8.5 inch x 11 inch (216 mm x 279 mm)
           Legal  : 8.5 inch x 14 inch (216 mm x 356 mm)

       Margins specified here do not always affect, sorry.

    \[$m(printertype)\]
       If you set $m(auto) here and your $m(faxagent) is efax, $m(printcmd) is
        taken from the valuable PRTYPE and PRINT defined in the file /etc/efax.rc.

    \[$m(printcmd)\] may be 'lpr' or'lp'. For example 'lpr -Plp0'
    to specify the print spool. See man pages of 'lpr' or'lp'.

\[$m(looks) tab\]
    Select the appearance of TkFax here.
    Colors do not change in the windows already opened.
    Open new window like '$m(help)' to see the efect. 

\[$m(letter_head)\]

    Set $m(header)s with your corporate name, sections,
    address, tel/fax numbers, etc.

\[$m(repetitives)\]

    Set here the Repetitive texts for the cover pages.

"

#----------------------------------------------------------------
# Usage of TkScan
#----------------------------------------------------------------

set c(usage) "
 This describes how to use $c(progname) Version $c(version).

 Contents

	1. Obtaining preview image
	2. Fixing a rectangle to be scanned
	3. Selection of scanning mode and resolution
	4. Output file specification
	5. Automatic output processing
	6. Scanning
	7. User Configuration
	8. Bug or Comment


 Section 1. Obtaining preview image

 * The preview mode and resolution can be chosen in Preference of File menu.
 * Click \[Preview\] button to start preview scanning.
   After scanning, preview image appears on the preview window.
 * Preview scanning can be interrupted by clicking \[Stop\] button.


 Section 2. Fixing a rectangle to be scanned

 * The selection of scanning regions on the preview image is done with the left
   mouse button. Press the left button at one corner of the rectangle you want
   to scan, move the mouse with left button pressed and release the button at
   the opposite corner of the rectangle.
 * You can finetune the rectangle using finetuning buttons (black triangles
   around blue rectangle on Geometry pannel).
 * While the blue rectagle on the preview window continuously shows a region
   to be scanned, Geometry pannel diplays coordinates of upper-left and
   lower-right coners, the width times height in the length unit chosen (Real
   Size) and in screen pixel (Screen Size), and the file size of the image in
   raw format (Data Size).  Screen Size and Data Size also vary as you change
   scanning mode and resolution.
 * The size of A4, Letter or others can be set using \[preset\] button.  You
   can add your own regions in configuration file (See Configuration section).
 * You can also select several regions on the preview image canvas.
   Fix a blue rectangle as described above and then click the middle mouse
   button with the mouse point inside the rectangle (or \[Regist\] button).
   The color of the rectangle becomes red and the number 1 appears at the
   center.  Then make another blue rectangle and press the middle
   button inside it.  Now the second rectangle is registered.  Repeat
   this as many times as you want.  Click of the right mouse button inside
   the red rectangle will remove it.  Double click of the right button (or
   click of the \[Clear\] button) deletes all rectangles.  TkScan will scan
   red rectangles one by one in order of their registration numbers.


 Section 3. Selection of scanning mode, resolution and options

 * This is transparent: Use mode \[Mode\] menubutton and \[Resolution\] scale.
   Screen Size and Data Size change accordingly as mode and resolution change.
 * If you want to adjust other options, press a small green button beside
   \[Mode\] menubutton.  Then the green button becomes red and the option
   manager window appears.  You can do it there.  Available options depend on
   the scanning mode.  Now clicking the button again makes the window disppear.
 * Several frequently used modes are preset in the configuration file and
   directly accessible via Mode munu.  You can define your own quick mode in
   the configuration file (See Configuration section.)


 Section 4. Output file specification

 * You can specify a filename for scanned image in \[Output to\] entry widget.
   If you use # and/or hhmmss in the filename, the last # is replaced with the
   retangle number(0 for blue rectangle, the number at the center for red
   rectangles) and hhmmss replaced with the time at which scanning started.
   The default filename is hhmmss-#.pnm. (You can change it in the configuration
   file.)
 * The file is written in the current directory, where you launched
   tkscan.  If you want to change the current directory, click the green button
   beside \[Output to\] entry widget.  Then the file manager window appears
   with the current directory name and the list of (image) files in the
   directory.  You can move to another directory by specifying the directory
   name in \[Directory\] entry widget or double clicking the directory name
   in the file list.


 Section 5. Automatic output processing

 $c(progname) can launch some application program to do necessary process on
 the image file after finishing scanning.  This is controlled in the file
 manager window which appears if the small green button beside
 \[Output to\] entry widget is pressed.  There are three check buttons
 to turn this feature on: View, Convert, Print.

 * View
   - If turned on, the image editor is automatically launched and show the
     scanned image after finishing scanning.
   - You can select image editor among XV, ImageMagic and GIMP in Preference.
   - There is also \[SW\] checkbutton in the preference window, which select
     that each scanned image appears in separate image editor or all images
     in one image editor when several red rectangles are scanned successively.

 * Convert
   - If turned on, the scanned image is converted to the file in the selected
     format, with the corresponding file surfix in the current directory.
     This is done by convert program from ImageMagic. So you need it.

 * Print
   - If turned on, the scanned image is converted to the postscript file and
     sent to the specified printer.  If you select gv as printer,
     gv(ghostview) will take up the postscript file.
   - You can adjust the size and position of the printed image using
     Zoom, X and Y entry widgets.

 \[Quick\] menu uses this automatic output processing to make the scanner
 be a copy machine (even though very poor, :-|), fax scanner.


 Section 6. Scanning

 This is done by pressing \[SCAN\] button. TkScan will scan the blue rectangle
 region. If you registered red rectangles, then red rectangle regions are
 scanned one by one and the blue rectangle is ignored even when it exists.
 As scanning is in progress, the progress report appears in the status bar.
 If you want to interrupt in the middle of scanning, press \[Stop\] button.
 It kill driver command and recover the state before scanning.
 If it does not work for some reason, double click \[Stop\] button. This
 surely stops scanning and recover TkScan for another scanning.
 Note that while \[Stop\] button kills scanning command immediately,
 it takes some time for scanner to respond.  Remember that scanner is a slowly
 responding peripharal.  I do not recommend frequent use of \[Stop\] button.


 Section 7. User Configuration

 If you select Preference in File menu, Preference Window appears.
 * Specify your scanner device if your scanner driver does not find the
   scanner device correctly without device option. Otherwise, to leave it
   blank is OK.
 * You can change the preview image mode and resolution to those you prefer.
   Press \[Apply\] button after selection.
 * Gamma correction can be done either by the driver itself or by the
   external programs like xv or ImageMagic's display or convert if it is
   not available in the driver. Choose what you prefer.
 * TkScan makes ~/.tkscan directory to keep its configuration files and
   scanned image files temporarily. You can delete those temporary files in
   this directory when exit or right now to free your hard disk.
 * If you select Save current config in File menu, the various configuration
   settings are stored in the ~/.tkscan/.conf file.  You can modify this file
   to fit your taste.  If you feel like doing more changes, look at the
   scan-conf.tcl script, copy necessary parts to ~/.tkscan/.conf file,
   and modify them.


 Section 8. Bug or Comment

 If you find a bug or have any comment on $c(progname) $c(version),
 please send a e-mail to hbkim@muon.kaist.ac.kr (Hang Bae Kim).

"

