#------------------------------------------------------------------------
# Sharp scanner via SANE - sharp.tcl - ver 0.11a
# 12 Jun 2001 - Masaki SHINOMIYA <shino@pos.to>
#               Seizo Murakami <panos@muc.biglobe.ne.jp>
# This script supports only essential functions 
# just for the lmodel JX-250
# The gamma/dropout options do not work! Probably I made some mistakes. 
# For other modeles, please add-on options  by yourself.
# 'scanimage --help' shows what options your scanner supports.
#------------------------------------------------------------------------

# Full scanning size. This should be in inches.
set s(scanwidth)	8.448
set s(scanheight)	11.68

# Minimum, maximum and step of scanning resolution in dpi
set s(resolutionRange)	{5 600 5}
# resolution range which your scanner realy supports
set s(resolutionSupported) {30 400}

# Time(in miliseconds) for coming back from the opposite end 
# after finishing full height scanning
set s(scantime)		20000

# Command-line driver
set s(command)	"scanimage"

# Scanner device (leave empty for autodetection)
set s(device)		"sharp"

# Options other than for mode and resolution
#     Label         Type  Variable      Values or Range  Default value
set s(optionList) { 
    { {Speed}          m  speed       {yes no}       yes }
    { {Threshold}      r  threshold   {0.1 0.9 0.1}  0.5 }
    { {Gamma}          m  gamma       {1.0 2.2}      1.0 }
}

set s(modedepoptionList) {threshold gamma}

# Supported scanning modes
#     Mode   Format  bpp  Mode-dependent options
set s(modeList) {
    { Lineart   pbm   1  {threshold}  }
    { Halftone  pbm   1  {gamma}      }
    { Gray      pgm   8  {gamma}      }
    { Color     ppm  24  {gamma}      }
}


set s(halftoning_support)	0

# Options the driver supports
# 1 : support by scanner driver
# 0 : support by external (image editor, image converter) commands
set s(halftoning_support)	0
set s(gamma_support)	    1

#------------------------------------------------------------------------
# Procedure launching scanner driver
#------------------------------------------------------------------------

proc run_scanner_driver { i file } { global s c
    set command $s(command)
    set prefix $file
    set tempfile  "$c(tkscandir)/$file.tmp"
    set file "$c(tkscandir)/$file.pnm"

    foreach j {tx ty bx by} { set $j [pixelto mm [expr $s($j$i)-$s(o)]] }
    set wd [expr $bx-$tx]
    set ht [expr $by-$ty]
    set geometry "-l $tx -t $ty -x $wd -y $ht"

    switch $s(mode) { 
        Lineart		{ 
                      set mode "--mode Lineart"
                      set post "$tempfile pbm:$file"
        }
        Halftone    { 
               if $s(halftoning_support) {
                      set mode "--mode Lineart"
                      set post "$tempfile pbm:$file"
               } else {
                      set mode "--mode Gray"
                      set post "-dither -monocrome $tempfile pbm:$file"
              }
        }
        Gray		{ set mode "--mode Gray"
                      set post "$tempfile pgm:$file" }
        Color		{ set mode "--mode Color"
                      set post "$tempfile ppm:$file" }
    }

    set reso $s(resolution)
    set reso_min [lindex $s(resolutionSupported) 0 ]
    set reso_max [lindex $s(resolutionSupported) end ]
    if       { $reso < $reso_min } { set reso $reso_min
    } elseif { $reso > $reso_max } { set reso $reso_max }    
    set resolution "--resolution $reso"

    if { $s(device) != "" } {
             set device "--device-name $s(device)"
    } else { set device "" }

    set option ""
    if { $s(speed) != "yes" } {append option " --speed $s(speed)"}
    foreach i $s($s(mode)option) { switch $i {
      threshold {
                 set th [expr int( 255*$s(threshold) + 0.5 ) ]
                 append option " --threshold $th"
           }
      gamma { if $s(gamma_support) {
                  append option " --gamma $s(gamma)"}}
           }
    }

    set unit mm
    set wd [expr int($s(resolution)*$wd/$s(c$unit))] 
    set ht [expr int($s(resolution)*$ht/$s(c$unit))]

    set cmdline "$command $device $mode $resolution $option $geometry \
                 > $tempfile; convert -geometry ${wd}x${ht} $post &"
### for debugging
#
#     tk_messageBox -message $cmdline  -type ok
###
    exec sh -c "$cmdline"
}

