# This file is a part of TkScan
# scan-win.tcl

#-------------------------------------------------------------------------
# Windows for Help menu

proc aboutWindow {} {
    global c m
    if [winfo exists .about] return
  # 25 Aug 2001 changed the directory name to 'images'
    image create photo hbkim -file $c(libdir)/images/hbkim.gif
    toplevel .about
    wm title .about "$c(progname): $m(about)"
    label .about.1 -text $c(about)
    label .about.2 -image hbkim
    label .about.3 -text $c(license)
    button .about.4 -width 8 -text OK -command "destroy .about"
    pack .about.1 .about.2 .about.3 .about.4 -side top
}

proc usageWindow {} {
    global c l m
    if [winfo exists .usage] return
    toplevel .usage
    wm title .usage "$c(progname): $m(guide)"
    frame .usage.b
    pack .usage.b -side top -fill x
    label .usage.b.1 -text "$c(progname) $c(version) User Guide" -width 20
    button .usage.b.2 -text $m(close) -command {destroy .usage}
    pack .usage.b.1 .usage.b.2 -side left
    frame .usage.u
    pack .usage.u -side top -fill both -expand yes
    text .usage.u.t -width 80 -height 20 -font $l(f1) \
         -yscrollcommand ".usage.u.s set"
    mscroll .usage.u.t
    scrollbar .usage.u.s -command ".usage.u.t yview" -orient vertical
    grid  .usage.u.t .usage.u.s -sticky news
    grid  rowconfigure    .usage.u 0 -weight 1
    grid  columnconfigure .usage.u 0 -weight 1
   .usage.u.t insert end $c(usage)
   .usage.u.t configure -state disabled
}

#--------------------------------------------------------------------
# optionWindow

proc optionWindow {} { global s w l c m
    set wo $w(main).option
    if [winfo exists $wo] {
        $w(optionbutton) configure -text " " \
            -bg $l(c7) -activebackground $l(c7)
        destroy $wo
        return
    }
    $w(optionbutton) configure -text " " \
	-bg $l(c8) -activebackground $l(c8)
    frame $wo -bd 5 -relief flat
    pack  $wo -side left -fill both

    # Label
    frame $wo.ti -bd 5
    pack  $wo.ti -side top
    label $wo.ti.l -text "$c(progname) $m(option_manager)" \
          -width 24 -padx 5 -pady 4 -relief ridge
    pack  $wo.ti.l -side top

    foreach i $s(optionList) {
        set Label       [lindex $i 0]
        set Type        [lindex $i 1]
        set Variable    [lindex $i 2]
        set Values      [lindex $i 3]
        set wn $wo.$Variable
        frame $wn
        pack  $wn -side top -fill x
        label $wn.l -text $Label -width 12 -anchor e
        switch $Type {
            s {}
            m {
                menubutton $wn.mb -menu $wn.mb.m -text $s($Variable) \
                  -anchor w -width 13 -padx 10 -pady 2 -relief ridge -fg $l(c1)
                menu $wn.mb.m -tearoff false
                pack $wn.l $wn.mb -side left
                foreach i $Values {
                    $wn.mb.m add command -label $i -command \
                             "set s($Variable) $i ; $wn.mb configure -text $i"
                }
            }
            r {
                entryscale $wn s($Variable) {} $Values 72
                pack $wn.l $wn.e $wn.s -side left
            }
        }
    }
    option_select
}

#-----------------------------------------------------------------
# Preference Window

proc preferenceWindow {} {
    global s c w l pr m

    set wn .pref
    if [winfo exists $wn] { return }
    toplevel $wn
    wm title $wn "$c(progname): $m(preference)"

    # Label

    frame $wn.ti -bd 5
    pack $wn.ti -side top
    label $wn.ti.l -text "$c(progname) $m(preference_manager)" \
          -width 24 -padx 10 -pady 4 -relief ridge
    pack $wn.ti.l -side top

    # Driver and Device

    set pd $wn.device
    frame $pd -bd 2 -relief groove
    frame $pd.u
    frame $pd.d
    frame $pd.h
    frame $pd.g
    pack $pd.u $pd.d $pd.h $pd.g -side top -fill x
    label $pd.u.l -text $m(scan_command) -anchor e -width 15 -pady 0
    label $pd.d.l -text $m(scan_device)  -anchor e -width 15 -pady 0
    entry $pd.u.d -textvariable s(command) \
          -width 20 -font $l(f1) -fg $l(c1) -relief sunken
    entry $pd.d.d -textvariable s(device) \
          -width 20 -font $l(f1) -fg $l(c1) -relief sunken
    pack $pd.u.l $pd.u.d -side left
    pack $pd.d.l $pd.d.d -side left

    label $pd.h.0 -text "Driver options" -anchor e -width 15 -pady 0
    checkbutton $pd.h.1 -text Halftoning -variable s(halftoning_support) -pady 0
    checkbutton $pd.h.2 -text Gamma -variable s(gamma_support) -pady 0
    pack $pd.h.0 $pd.h.1 $pd.h.2 -side left

    # Preview

    set pp $wn.preview
    frame $pp -bd 1 -relief groove
    frame $pp.m
    frame $pp.r
    pack $pp.m $pp.r -side top -fill x
    label $pp.m.p -text $m(preview_mode) -anchor e -width 15 -pady 0
    label $pp.r.l -text $m(resolution) -width 15 -padx 0 -anchor e
    menubutton $pp.m.m -menu $pp.m.m.m \
               -width 10 -pady 0 -relief ridge -fg $l(c1)
    entryscale $pp.r s(prepreresolution) {} $s(preresolutionRange) 60
    button $pp.r.b -text $m(apply) -width 5 -padx 0 -pady 0 \
              -command {setpreresolution $s(prepreresolution)}
    pack $pp.m.p $pp.m.m -side left
    pack $pp.r.l $pp.r.e $pp.r.s $pp.r.b -side left
    menu $pp.m.m.m -tearoff false
    foreach i $s(modeList) { set modename [lindex $i 0]
        $pp.m.m.m add command -label $modename -command "setpremode $modename"
    }
    $pp.m.m.m add command -label Current -command "setpremode Current"
    set w(premodebutton) $pp.m.m
    set s(prepreresolution) $s(preresolution)
    setpremode $s(premode)

    # Gamma support

#    set pg $wn.gamma
#    frame $pg -bd 1 -relief groove
#    label $pg.l -text "Gamma Support" -anchor e -width 15 -pady 0
#    radiobutton $pg.1 -text Driver -variable s(gamma_support) -value 0 -pady 0
#    radiobutton $pg.2 -text External -variable s(gamma_support) -value 1 -pady 0
#    pack $pg.l $pg.1 $pg.2 -side left

    # Image Editor

    set ie $wn.ie
    frame $ie -bd 1 -relief groove
    label $ie.l -text "Image Editor" -anchor e -width 15 -pady 0
    menubutton $ie.mb -menu $ie.mb.m -text $c(ImageEditor) \
               -width 12 -pady 0 -relief ridge -fg $l(c1)
    checkbutton $ie.cb -text SW -variable c(ImageEditorWinmode) -pady 0
    pack $ie.l $ie.mb $ie.cb -side left
    menu $ie.mb.m -tearoff false
    foreach i $c(ImageEditorList) { set iename [lindex $i 0]
        $ie.mb.m add command -label $iename -command "
            $ie.mb configure -text $iename
            set c(ImageEditor) $iename
        "
    }

    # Printer paper

    set pa $wn.paper
    frame $pa -bd 1 -relief groove
    frame $pa.1
    frame $pa.2
    pack $pa.1 $pa.2 -side top -fill x
    label $pa.1.l -text $m(print_command) -anchor e -width 15 -pady 0
    label $pa.2.l -text $m(printer_paper) -anchor e -width 15 -pady 0
    entry $pa.1.1 -textvariable pr(lpcommand) \
          -width 20 -font $l(f1) -fg $l(c1) -relief sunken
    radiobutton $pa.2.1 -text A4 -variable pr(paper) -value A4 -pady 0
    radiobutton $pa.2.2 -text Letter -variable pr(paper) -value Letter -pady 0
    pack $pa.1.l $pa.1.1 -side left
    pack $pa.2.l $pa.2.1 $pa.2.2 -side left

    # Temporary directory

    set pt $wn.tmpdir
    frame $pt -bd 1 -relief groove
    frame $pt.u
    frame $pt.d
    pack $pt.u $pt.d -side top -fill x
    label $pt.u.1 -text $m(tmp_directory) -anchor e -width 15 -pady 0
    checkbutton $pt.u.2 -text $m(clear_when_exit) -variable c(tmpdirclear) \
                -pady 0
    pack $pt.u.1 $pt.u.2 -side left -fill x
    label $pt.d.1 -text "" -anchor e -width 15 -pady 0
    button $pt.d.2 -text $m(clear_now) -command clear_tkscandir \
           -width 12 -pady 0
    pack $pt.d.1 $pt.d.2 -side left -fill x

    # Packing all subframes

#    pack $pd $pp $pg $ie $pa $pt -side top -fill x
    pack $pd $pp $ie $pa $pt -side top -fill x

    # Buttons

    set pb $wn.button
    frame $pb -bd 5
    pack $pb -side bottom -expand yes -fill x
    button $pb.h -text $m(close) -command "destroy $wn" -pady 0
    pack $pb.h -side left -expand yes -fill x
}

