/* settingsMode.h
   Allows the user to change game settings

   Copyright (C) 2003  Mathias Broxvall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SETTINGSMODE_H
#define SETTINGSMODE_H

class SettingsMode : public GameMode {
 public:
  SettingsMode();
  void display();
  void activated();
  void deactivated();
  void key(int);
  void idle(Real);
  void mouseDown(int state,int x,int y);

  static void init();
  static SettingsMode *settingsMode;
 private:

   enum SettingLabels
   {
      SETTING_RETURN            = -2,
      SETTING_MOUSE_SENSITIVITY = 0,
      SETTING_SCREEN_RESOLUTION,
      SETTING_GFX_DETAILS,
      SETTING_SCREEN_WINDOWED,
      SETTING_SHOW_FPS,
      SETTING_MUSIC_VOLUME,
      SETTING_EFFECTS_VOLUME,
      SETTING_JOYSTICK,
      // make sure the NUM_SETTINGS REMAINS LAST!!!
      NUM_SETTINGS
    };

  static SDL_Surface *title, *labels[NUM_SETTINGS], *return2menu,*return2menuHigh;
  int selected;

  void displayMenu(SDL_Surface *image,char *str,int position);
};

#endif
