/*	run.c - Created by Giampiero Caprino

This file is part of Train Director

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>

#if !defined(__unix__)
#include <malloc.h>
#else
#include <stdlib.h>
#endif
#include <math.h>
#include "ask.h"
#include "trsim.h"

	Vector	*new_Vector(void);
	void	Vector_addElement(Vector *v, void *e, int flag);
	void	*Vector_elementAt(Vector *v, int i);
	int	Vector_flagAt(Vector *v, int i);
	void	Vector_empty(Vector *v);
	void	Vector_delete(Vector *v);
	void	Vector_deleteElement(Vector *v, int del);
	int	Vector_find(Vector *v, Track *trk);
	void	Vector_merge(Vector *dest, Vector *src);
	void	Vector_Print(Vector *v, char * str, short pos);
	void	Vector_dump(Train *tr, char *suff);
	int	sameSubPath(Vector *v1, Vector *v2);
	Vector	*appendPath(Vector *oldpath, Vector *newelems);

Itinerary *find_from_to(Track *from, Track *to)
{
	/*

	    Brute force approach:

	    - create a list of all the switches in the layout
	    - save current state of all switches
	    - create a bit set, one bit per switch; set to 0
	    - set switches state according to values in the bit set
	    - if path exist between from and to, save path and switches state
	    - increment bit set
	    - repeat until all bits are 0 (overflowed)
	    - if more than one path found, select best path


	    More intelligent approach:

	    - get all switches
	    - get all signal + entries
	    - create matrix x * x
	    - for each x signal/entry
	    -- for each y signal/entry
	    --- do walk
	    ---- walk up to next switch / signal / entry
	    ---- if switch reached
	    ----- stack += switch state = 0
	    ----- stack += switch state = 1
	    ---- else
	    ----- set matrix[x][y] = path;
	    ----- if stack empty, break loop
	    ---- pop stack, set switch state
	    --- continue walking
	    -- next y
	    - next x


	 */

}
