/*	ui.h - Created by Giampiero Caprino

This file is part of Train Director

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#ifndef _UI_H
#define	_UI_H

struct tr_rect {
	int	left, top;
	int	right, bottom;
};

typedef struct {
	char	*text;
	char	*cmd;
	void	*handle;
} TrButton;

typedef	struct {
	long	x0, y0;
	long	x1, y1;
} VLines;

typedef enum {
	SEG_N = 0,
	SEG_NE = 1,
	SEG_E = 2,
	SEG_SE = 3,
	SEG_S = 4,
	SEG_SW = 5,
	SEG_W = 6,
	SEG_NW = 7,
	SEG_END = 8
} SegDir;

typedef struct {
	char	*text;
	char	oldtext[256];
	void	*handle;
} TrLabel;

struct edittools {
	int	type;
	int	direction;
	int	x, y;
	Track	*trk;
};

struct clist {
	char	*title;
	char	**headers;
	int	*col_width;
	char	*(*col_string)(int row, int col, void *ptr);
};

#ifdef __cplusplus
extern "C" {
#endif
extern	struct tr_rect cliprect;
extern	struct edittools *tooltbl;
extern	TrButton buttonRow[];
extern	TrLabel	labelList[];	/* for messages, scores etc. */

	void	init_pmaps(void);
	void	draw_layout_text(int x, int y, char *msg);
	void	tr_fillrect(int x, int y);
	void	draw_layout(int x, int y, VLines *lns, int color);
	void	draw_pixmap(int x, int y, void *pmap);
#ifdef __cplusplus
};
#endif

#endif /* _UI_H */

