/*	button.c - Created by Giampiero Caprino

This file is part of Train Director

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gtk/gtk.h"
#include "trsim.h"

gint button_event( GtkWidget *widget,
		 GdkEvent  *event,
		 gpointer   data )
{
	int	i;

	for(i = 0; buttonRow[i].text; ++i) {
	    if(widget != buttonRow[i].handle)
		continue;
	    trainsim_cmd(buttonRow[i].cmd);
	    return(TRUE);
	}
	return(FALSE);
}

void	update_button(char *cmd, char *lbltxt)
{
	int	i;
	GtkWidget *lbl;

	for(i = 0; buttonRow[i].text; ++i) {
	    if(!strcmp(cmd, buttonRow[i].cmd)) {
		gtk_object_set(GTK_OBJECT(buttonRow[i].handle),
			"label", lbltxt, NULL);
		return;
	    }
	}
}

/* Make a new hbox filled with button-labels. Arguments for the 
* variables we're interested are passed in to this function. 
* We do not show the box, but do show everything inside. */
GtkWidget *make_box(gint homogeneous,
		   gint spacing,
		   gint expand,
		   gint fill,
		   gint padding ) 
{
	GtkWidget *box;
	GtkWidget *button;
	int	i;

	/* Create a new hbox with the appropriate homogeneous
	 * and spacing settings */
	box = gtk_hbox_new (homogeneous, spacing);

	/* Create a series of buttons with the appropriate settings */
	for(i = 0; buttonRow[i].text; ++i) {
	    button = gtk_button_new_with_label (L(buttonRow[i].text));
	    gtk_signal_connect(GTK_OBJECT (button), "clicked",
                              GTK_SIGNAL_FUNC (button_event), buttonRow[i].cmd);
	    gtk_box_pack_start(GTK_BOX (box), button, expand, fill, padding);
	    gtk_widget_show(button);
	    buttonRow[i].handle = button;
	}

	return box;
}

void	create_button_bar(GtkWidget *window, GtkWidget *box1)
{
	GtkWidget *box2;

	/* Call our make box function - homogeneous = FALSE, spacing = 0,
	* expand = FALSE, fill = FALSE, padding = 0 */
	box2 = make_box (TRUE, 0, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, FALSE, 0);
	gtk_widget_show (box2);
}

