/*	gtkask.c - Created by Giampiero Caprino

This file is part of Train Director

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include "ask.h"



static	yesno	answer;
static	GtkWidget *dlg_handle;

static	gboolean cmw_destroy_cb(GtkWidget *widget)
{
	gtk_main_quit();
	return FALSE;
}

static	gboolean cmw_answer_yes(GtkWidget *widget)
{
	answer = ANSWER_YES;
	gtk_widget_destroy(dlg_handle);
	return FALSE;
}

static	gboolean cmw_answer_no(GtkWidget *widget)
{
	answer = ANSWER_NO;
	gtk_widget_destroy(dlg_handle);
	return FALSE;
}

static	yesno	gtk_ask(char *msg, int type)
{
	GtkWidget *window;
	GtkWidget *vbox, *hbox;
	GtkWidget *child;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_modal(GTK_WINDOW(window),TRUE);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", 
		      GTK_SIGNAL_FUNC(cmw_destroy_cb), 
		      window);
	gtk_window_set_title(GTK_WINDOW(window),localize("Reply"));
	vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_border_width(GTK_CONTAINER(vbox), 10);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	child = gtk_label_new(msg);
	gtk_box_pack_start(GTK_BOX(vbox), child, FALSE, TRUE, 0);
	child = gtk_label_new(" ");
	gtk_box_pack_start(GTK_BOX(vbox), child, FALSE, TRUE, 0);

	hbox = gtk_hbox_new(TRUE, 1);
	gtk_container_border_width(GTK_CONTAINER(hbox), 10);
	gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);

	if(type == 1) {
	    child = gtk_button_new_with_label(localize("Yes"));
	    gtk_box_pack_start(GTK_BOX(hbox), child, TRUE, FALSE, 0);
	    gtk_signal_connect(GTK_OBJECT(child), "clicked", 
		      GTK_SIGNAL_FUNC(cmw_answer_yes), window);
	    child = gtk_button_new_with_label(localize("No"));
	} else if(type == 2) {
	    child = gtk_button_new_with_label(localize("Continue"));
	    gtk_box_pack_start(GTK_BOX(hbox), child, TRUE, FALSE, 0);
	    gtk_signal_connect(GTK_OBJECT(child), "clicked", 
		      GTK_SIGNAL_FUNC(cmw_answer_yes), window);
	    child = gtk_button_new_with_label(localize("Cancel"));
	} else
	    child = gtk_button_new_with_label(localize("Ok"));
	gtk_box_pack_start(GTK_BOX(hbox), child, TRUE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(child), "clicked", 
		      GTK_SIGNAL_FUNC(cmw_answer_no), window);
	gtk_box_pack_end(GTK_BOX(vbox), gtk_hseparator_new(), FALSE, FALSE, 0);
	dlg_handle = window;
	answer = ANSWER_NO;
	gtk_widget_show_all(window);

	gtk_main();

	return answer;
}

yesno	ask(char *msg)
{
	return gtk_ask(msg, 1);
}

yesno	cont(char *msg)
{
	return gtk_ask(msg, 2);
}

void	error(char *msg)
{
	gtk_ask(msg, 3);
}

