#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include "trsim.h"
#include "gtktrain.h"
#include "ask.h"

extern	char	*version;

void	init_gtk_dialogs(void);
void	create_itinerary_table(GtkWidget *, GtkWidget*);

int	status_on_top = 1;
int	screen_width = 1024;

GtkWidget *top_line, *bottom_line;

extern	void	click_time(void);

gint	timer_tag;

gint	timer_fired(gpointer data)
{
	click_time();
	return(running);
}

void	make_timer(int msec)
{
	if(!msec)
	    gtk_timeout_remove(timer_tag);
	else
	    timer_tag = gtk_timeout_add(msec, timer_fired, 0);
}

void	create_colors(void)
{
	/*gdk_rgb_set_verbose(TRUE);*/

	gdk_rgb_init();

	gtk_widget_set_default_colormap(gdk_rgb_get_cmap());
	gtk_widget_set_default_visual(gdk_rgb_get_visual());

	color_black = 0;
	color_white = 1;
	color_green = 2;
	color_yellow = 3;
	color_red = 4;
	color_orange = 5;
	color_brown = 6;
	color_gray = 7;
	color_lightgray = 8;
	color_darkgray = 9;
	color_blue = 10;
	color_cyan = 11;

	fieldcolors[COL_BACKGROUND] = color_lightgray;
	fieldcolors[COL_TRACK] = color_black;
	fieldcolors[COL_GRAPHBG] = color_lightgray;

	fieldcolors[COL_TRAIN1] = color_orange;
	fieldcolors[COL_TRAIN2] = color_cyan;
	fieldcolors[COL_TRAIN3] = color_blue;
	fieldcolors[COL_TRAIN4] = color_yellow;

}

void	create_main_window(char *title, GtkWidget **wp, GtkWidget **box)
{
	GtkWidget *window;
	GtkWidget *main_vbox;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", 
		      GTK_SIGNAL_FUNC(gtk_main_quit), 
		      "WM destroy");
	gtk_window_set_title(GTK_WINDOW(window), title);
	gtk_widget_set_usize(GTK_WIDGET(window), 680, 480);
	main_vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_border_width(GTK_CONTAINER(main_vbox), 1);
	gtk_container_add(GTK_CONTAINER(window), main_vbox);
	gtk_widget_show(main_vbox);
	*wp = window;
	*box = main_vbox;
}

void	create_menu(GtkWidget *window, GtkWidget *box)
{
	GtkWidget *menubar;

	get_main_menu(window, &menubar);
	gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, TRUE, 0);
	gtk_widget_show(menubar);
}

void	repaint_labels()
{
	int	i;

	for(i = 0; i < 8; ++i)
	    if(labelList[i].handle &&
		strcmp(labelList[i].text, labelList[i].oldtext)) {
		gtk_label_set_justify(GTK_LABEL(labelList[i].handle), GTK_JUSTIFY_LEFT);
		gtk_label_set_text(GTK_LABEL(labelList[i].handle),
			labelList[i].text);
		strncpy(labelList[i].oldtext, labelList[i].text,
			sizeof(labelList[i].oldtext));
		labelList[i].oldtext[sizeof(labelList[i].oldtext) - 1] = 0;
	    }
}

GtkWidget *create_status_line(GtkWidget *window, GtkWidget *box)
{
	GtkWidget *menubar;

	menubar = gtk_label_new("");
	gtk_label_set_justify(GTK_LABEL(menubar), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, TRUE, 0);
	return menubar;
}

void	new_status_position(void)
{
	if(status_on_top) {
	    gtk_widget_hide(bottom_line);
	    gtk_widget_show(top_line);
	    labelList[7].handle = top_line;
	} else {
	    gtk_widget_hide(top_line);
	    gtk_widget_show(bottom_line);
	    labelList[7].handle = bottom_line;
	}
	repaint_labels();
}

int main(int argc, char *argv[])
{
	GtkWidget *window;
	GtkWidget *main_vbox;

	char	buff[256];

	gtk_set_locale();
	gtk_init(&argc, &argv);

#if defined(__unix__)
	if(getenv("TDHOME"))
	    chdir(getenv("TDHOME"));
#endif
	load_ini_file();

	screen_width = gdk_screen_width();

	create_colors();

	init_gtk_dialogs();

	trainsim_init();

	sprintf(buff, "Train Director %s", version);
        create_main_window(buff, &window, &main_vbox);
        create_menu(window, main_vbox);
        create_button_bar(window, main_vbox);
        create_table(window, main_vbox);
        labelList[7].handle = top_line = create_status_line(window, main_vbox);
	if(status_on_top)
	    gtk_widget_show(top_line);
        create_toolbox(window, main_vbox);
	create_itinerary_table(window, main_vbox);
        create_field(window, main_vbox);
	bottom_line = create_status_line(window, main_vbox);
	if(!status_on_top)
	    gtk_widget_show(bottom_line);
        show_table();

	gtk_widget_show(window);
	init_pmaps();
	if(argc > 1) {
	    update_last_file(argv[1]);
	    save_last();
	    sprintf(buff, "open %s", argv[1]);
	    trainsim_cmd(buff);
	}
	invalidate_field();
	repaint_all();
	repaint_labels();

	gtk_main();

	return(0);
}

void	main_quit_cmd()
{
	save_ini_file();
	gtk_main_quit();
}

