/*	gtkpen.c - Created by Giampiero Caprino

This file is part of Train Director

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gtkopen.h"
#include "trsim.h"

static	GtkWidget *filew;
static	char	open_file_name[256];

static	void file_ok_sel(GtkWidget *w, GtkFileSelection *fs)
{
	char	*p;
#if defined(__unix__)
	int	i;
#endif

	if(!(p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)))) {
	    gtk_widget_destroy(GTK_WIDGET(fs));
	    gtk_main_quit();
	    return;
	}
	strncpy(open_file_name, p, sizeof(open_file_name));
	curpath = g_dirname(open_file_name);/* get current dir name */
	gtk_widget_destroy(GTK_WIDGET(fs));
	gtk_main_quit();
}

int	openFileDialog(char *dst)
{
	open_file_name[0] = 0;

	/* Create a new file selection widget */
        filew = gtk_file_selection_new(L("File selection"));
          
        gtk_signal_connect(GTK_OBJECT (filew), "destroy",
                              (GtkSignalFunc) gtk_widget_destroy, &filew);
        /* Connect the ok_button to file_ok_sel function */
        gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
                              "clicked", (GtkSignalFunc) file_ok_sel, filew );
          
        /* Connect the cancel_button to destroy the widget */
        gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION
                                                (filew)->cancel_button),
                                 "clicked", (GtkSignalFunc) gtk_widget_destroy,
                                 GTK_OBJECT (filew));
          
        gtk_file_selection_set_filename(GTK_FILE_SELECTION(filew), "default");

        gtk_widget_show(filew);

	gtk_main();

	if(!open_file_name[0])
	    return 0;
	strcpy(dst, open_file_name);
	return 1;
}

int	openImageDialog(char *dst)
{
	return openFileDialog(dst);
}

int	saveFileDialog(char *dst)
{
	/* TODO */
	return 0;
}

void	alert_beep(void)
{
#ifdef unix
	gdk_beep();
#else
	fprintf(stderr, "\007");
	fflush(stderr);
#endif
}
