/*	ui.h - Created by Giampiero Caprino
Modified by Erik Kuiper

This file is part of Train Director

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include "html.h"

static	FILE	*fhtml;

void	html_startpage(FILE *fp, char *title)
{
	fhtml = fp;
	fprintf(fp, "<html>\n");
	fprintf(fp, "<head><title>%s</title></head>\n", title);
	fprintf(fp, "<body bgcolor=\"#FFFFFF\" text=\"#000000\">\n");
	fprintf(fp, "<center><h1>%s</h1></center>\n", title);
	fprintf(fp, "<hr>\n");
}

void	html_table(char **headers)
{
	int	i;
	fprintf(fhtml, "<center><table cellspacing=6>\n");
	fprintf(fhtml, "<tr bgcolor=\"#00ffcc\">\n");
	for(i = 0; headers[i]; ++i)
	    fprintf(fhtml, "<td>%s</td>\n", headers[i]);
	fprintf(fhtml, "</tr>\n\n");
}

void	html_row(char **values)
{
	int	i;

	fprintf(fhtml, "<tr VALIGN=TOP>\n");
	for(i = 0; values[i]; ++i)
	    fprintf(fhtml, "<td valign=top>%s</td>\n",
			*values[i] ? values[i] : "&nbsp;");
	fprintf(fhtml, "</tr>\n\n");
}

void	html_endtable(void)
{
	fprintf(fhtml, "</table></center>\n<hr>\n\n");
}

void	html_endpage(void)
{
	fprintf(fhtml, "</body></html>\n");
}

