#!/bin/sh
# $Id: setup_trdir.sh,v 1.2 2004/03/11 05:25:09 claude Exp $
# Setup for traindir
#
# if you have put your file in another location
# edit the folowing line
#
# This is the place where traindirector is installed
TRAINDIR="/usr/local/bin"
# This is the place where samples file is installed
SAMPLE="/usr/local/share"
##################################################################"
echo "*********************************"
echo "*  Traindirector Installation   *"
echo "*********************************"
echo
echo  "Making traindir samples directory....."
echo 
TDHOMEDIR="$HOME/traindir"
ICONDIR="$TDHOMEDIR/tdicons"
LOCALEDIR="$TDHOMEDIR/locales"
if ! test -d $TDHOMEDIR  ; then
    mkdir $TDHOMEDIR
fi

if ! test -d $ICONDIR ; then
mkdir $ICONDIR
fi

echo "Setting language for Traindir"
echo "1 English (default)"
echo "2 Italiano"
echo "3 Franais"
echo "4 Interlingua"
echo -n "Choose language [1]>" 

read CHOIX

case $CHOIX in
    "2") FLNAME=".traindir.it"
         echo " Avette schelto Italiano"
         STRING='locale .it';;
	 	 
    "3") FLNAME=".traindir.fr"
         echo "Vous Avez choisi Franais"
	 STRING='locale .fr';;
	 
    "4") FLNAME=".traindir.ia"
         echo "Vos ha selectionate Interlingua"
	 STRING='locale .ia';;
	 
      *)echo "Language set to default (English)"
        STRING='locale .en';;
esac 

if ! test -d $HOME/.traindir ; then
    mkdir $HOME/.traindir
fi
    echo $STRING > $HOME/.traindir/.traindir.ini
    cp -f $SAMPLE/traindir/locales/$FLNAME $HOME/.traindir/

cp -f $SAMPLE/traindir/* $TDHOMEDIR
cp -f $SAMPLE/traindir/tdicons/*.*  $ICONDIR 


echo
echo   "Creating startup script......"
echo
echo   "#!/bin/sh" > $HOME/traindir.sh
echo   "# Startup file for traindirector" >> $HOME/traindir.sh
echo   "#" >> $HOME/traindir.sh
echo   "TDHOME=\"$HOME/traindir\"" >> $HOME/traindir.sh
echo   "export TDHOME" >> $HOME/traindir.sh
echo   "echo starting Traindirector" >> $HOME/traindir.sh
echo   "$TRAINDIR/traindir" >> $HOME/traindir.sh

chmod 0775 $HOME/traindir.sh
echo "Installation complete"
echo "You can run ~/traindir.sh from a X console"

