/*	table.c - Created by Giampiero Caprino

This file is part of Train Director

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>
#include "trsim.h"

GtkWidget *table;

/* This callback quits the program */
gint delete_event( GtkWidget *widget,
		 GdkEvent  *event,
		 gpointer   data )
{
	gtk_main_quit();
	return(FALSE);
}

void hide_table()
{
	gtk_widget_hide(table);
}

void show_table()
{
	gtk_widget_show(table);
}

void create_table(GtkWidget *window, GtkWidget *vbox)
{
	GtkWidget *lbl;
	int	i;

	table = gtk_table_new(3, 1, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

	for(i = 0; i < 3; ++i) {
	    lbl = gtk_label_new(labelList[i].text);
	    gtk_misc_set_alignment(GTK_MISC(lbl), 0.0, 0.5);
	    gtk_table_attach_defaults(GTK_TABLE(table), lbl, i, i + 1, 0, 1);
	    gtk_widget_show (lbl);
	    labelList[i].handle = lbl;
	    strcpy(labelList[i].oldtext, labelList[i].text);

/*	    lbl = gtk_label_new(labelList[i + 3].text);
	    gtk_misc_set_alignment(GTK_MISC(lbl), 0.0, 0.5);
	    gtk_table_attach_defaults(GTK_TABLE(table), lbl, i, i + 1, 1, 2);
	    gtk_widget_show(lbl);
	    labelList[i + 3].handle = lbl;
	    strcpy(labelList[i + 3].oldtext, labelList[i + 3].text);*/
	}
}

