#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "trsim.h"		    /* just for L() */

#pragma argsused

extern	HINSTANCE   ghInstance;

extern	int is_windows;

static char szName[128];	    /* file selection values */
static char commondir[128];

void	CenterDialog(HWND hWnd)
{
	RECT	rc;

	GetWindowRect(hWnd, &rc);
	SetWindowPos(hWnd, NULL,
		(GetSystemMetrics(SM_CXSCREEN) - (rc.right - rc.left)) / 2,
		(GetSystemMetrics(SM_CYSCREEN) - (rc.bottom - rc.top)) / 3,
		0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

int	openFileDialog1(char *dst, char *sel)
{
	HWND	hWnd;
	static OPENFILENAME ofnTemp;
	DWORD Errval;	/* Error value */
	char *p;
	char buf[5];	/* Error buffer */
	char Errstr[50]="GetOpenFileName returned Error #";
	char *szMask;
	static char szTemp[128];
/*
Note the initialization method of the above string.  The GetOpenFileName()
function expects to find a string in the OPENFILENAME structure that has
a '\0' terminator between strings and an extra '\0' that terminates the
entire filter data set.  Using the technique shown below will fail because
"X" is really 'X' '\0' '\0' '\0' in memory.  When the GetOpenFileName()
function scans szTemp it will stop after finding the extra trailing '\0'
characters.

	char szTemp[][4] = { "X", "*.*", "ABC", "*.*", "" };

The string should be "X\0*.*\0ABC\0*.*\0".

Remember that in C or C++ a quoted string is automatically terminated with
a '\0' character so   char "X\0";   would result in 'X' '\0' '\0' which
provides the extra '\0' that GetOpenFileName() needs to see in order to
terminate the scan of the string.  Just 'char ch "X";' would result in 'X'
'\0' and GetOpenFileName() would wander off in memory until it lucked into
a '\0' '\0' character sequence.
*/

/*
Some Windows structures require the size of themselves in an effort to
provide backward compatibility with future versions of Windows.  If the
lStructSize member is not set the call to GetOpenFileName() will fail.
*/
	/* hWnd = ghWndFrame; */
	hWnd = GetActiveWindow();
	ofnTemp.lStructSize = sizeof( OPENFILENAME );
	ofnTemp.hwndOwner = hWnd;	/* An invalid hWnd causes non-modality */
	ofnTemp.hInstance = 0;
	p = szTemp;
	szMask = sel;
	for(;;) {
	    if(!(*p++ = *szMask++)) {
		if(!*szMask)
		    break;
	    }
	}
	*p = 0;
	ofnTemp.lpstrFilter = (LPSTR)szTemp;	/* See previous note concerning string */
	ofnTemp.lpstrCustomFilter = NULL;
	ofnTemp.nMaxCustFilter = 0;
	ofnTemp.nFilterIndex = 1;
	strcpy(szName, dst);			/* provide default */
	ofnTemp.lpstrFile = (LPSTR)szName;	/* Stores the result in this variable */
	ofnTemp.nMaxFile = sizeof( szName );
	ofnTemp.lpstrFileTitle = NULL;
	ofnTemp.nMaxFileTitle = 0;
	ofnTemp.lpstrInitialDir = commondir;
	ofnTemp.lpstrTitle = L("Open File");
	ofnTemp.Flags = OFN_PATHMUSTEXIST;
	ofnTemp.nFileOffset = 0;
	ofnTemp.nFileExtension = 0;
	ofnTemp.lpstrDefExt = "*";
	ofnTemp.lCustData = NULL;
	ofnTemp.lpfnHook = NULL;
	ofnTemp.lpTemplateName = NULL;
/*
If the call to GetOpenFileName() fails you can call CommDlgExtendedError()
to retrieve the type of error that occured.
*/
	if(GetOpenFileName(&ofnTemp) != TRUE) {
		Errval = CommDlgExtendedError();
		if(Errval) {	/* 0 value means user selected Cancel */
			sprintf(buf, "%ld", Errval);
			strcat(Errstr, buf);
			MessageBox(hWnd, Errstr, L("Error"), MB_OK|MB_ICONSTOP);
		}
		return(0);
	}
#if 0
	if(p = strrchr(szName, '\\')) {
	    strcpy(commondir, szName);
	    if(p = strrchr(commondir, '\\'))
		*p = 0;
	}
#endif
	strcpy(dst, szName);
	return(1);
}

int	openFileDialog(char *dst)
{
	char	*p;
	char	buff[256];

	strcpy(buff, L("Scenarios"));
	p = buff + strlen(buff) + 1;
	strcpy(p, "*.trk");
	p = p + strlen(p) + 1;
	strcpy(p, L("Saved games"));
	p = p + strlen(p) + 1;
	strcpy(p, "*.sav");
	p = p + strlen(p) + 1;
	strcpy(p, L("All files (*.*)"));
	p = p + strlen(p) + 1;
	strcpy(p, "*.*");
	p[strlen(p) + 1] = 0;
//	return openFileDialog1(dst, "Layouts\0*.trk\0Saved games\0*.sav\0All files (*.*)\0*.*\0");
	return openFileDialog1(dst, buff);
}

int	openImageDialog(char *dst)
{
	char	*p;
	char	buff[256];

	strcpy(buff, L("Icons"));
	p = buff + strlen(buff) + 1;
	strcpy(p, "*.xpm");
	p = p + strlen(p) + 1;
	strcpy(p, L("All files (*.*)"));
	p = p + strlen(p) + 1;
	strcpy(p, "*.*");
	p[strlen(p) + 1] = 0;
	return openFileDialog1(dst, buff);
//	return openFileDialog1(dst, "Icons\0*.xpm\0All files (*.*)\0*.*\0");
}

int	saveFileDialog(char *dst)
{
	HWND	hWnd;
	static OPENFILENAME ofnTemp;
	DWORD Errval;	/* Error value */
/*	char *p; */
	char buf[5];	/* Error buffer */
	char Errstr[50]="GetOpenFileName returned Error #";
	static char szMask[] = "Layouts\0*.trk\0All files (*.*)\0*.*\0";
	static char szTemp[128];
/*
Note the initialization method of the above string.  The GetOpenFileName()
function expects to find a string in the OPENFILENAME structure that has
a '\0' terminator between strings and an extra '\0' that terminates the
entire filter data set.  Using the technique shown below will fail because
"X" is really 'X' '\0' '\0' '\0' in memory.  When the GetOpenFileName()
function scans szTemp it will stop after finding the extra trailing '\0'
characters.

	char szTemp[][4] = { "X", "*.*", "ABC", "*.*", "" };

The string should be "X\0*.*\0ABC\0*.*\0".

Remember that in C or C++ a quoted string is automatically terminated with
a '\0' character so   char "X\0";   would result in 'X' '\0' '\0' which
provides the extra '\0' that GetOpenFileName() needs to see in order to
terminate the scan of the string.  Just 'char ch "X";' would result in 'X'
'\0' and GetOpenFileName() would wander off in memory until it lucked into
a '\0' '\0' character sequence.
*/

/*
Some Windows structures require the size of themselves in an effort to
provide backward compatibility with future versions of Windows.  If the
lStructSize member is not set the call to GetOpenFileName() will fail.
*/
	/* hWnd = ghWndFrame; */
	hWnd = GetActiveWindow();
	ofnTemp.lStructSize = sizeof( OPENFILENAME );
	ofnTemp.hwndOwner = hWnd;	/* An invalid hWnd causes non-modality */
	ofnTemp.hInstance = 0;
	memcpy(szTemp, szMask, sizeof(szMask));
	ofnTemp.lpstrFilter = (LPSTR)szTemp;	/* See previous note concerning string */
	ofnTemp.lpstrCustomFilter = NULL;
	ofnTemp.nMaxCustFilter = 0;
	ofnTemp.nFilterIndex = 1;
	ofnTemp.lpstrFile = (LPSTR)szName;	/* Stores the result in this variable */
	ofnTemp.nMaxFile = sizeof( szName );
	ofnTemp.lpstrFileTitle = NULL;
	ofnTemp.nMaxFileTitle = 0;
	ofnTemp.lpstrInitialDir = commondir;
	ofnTemp.lpstrTitle = L("Save File");
	ofnTemp.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST;
	ofnTemp.nFileOffset = 0;
	ofnTemp.nFileExtension = 0;
	ofnTemp.lpstrDefExt = "*";
	ofnTemp.lCustData = NULL;
	ofnTemp.lpfnHook = NULL;
	ofnTemp.lpTemplateName = NULL;
/*
If the call to GetOpenFileName() fails you can call CommDlgExtendedError()
to retrieve the type of error that occured.
*/
	if(GetSaveFileName(&ofnTemp) != TRUE) {
		Errval = CommDlgExtendedError();
		if(Errval) {	/* 0 value means user selected Cancel */
			sprintf(buf, "%ld", Errval);
			strcat(Errstr, buf);
			MessageBox(hWnd, Errstr, L("Error"), MB_OK|MB_ICONSTOP);
		}
		return(0);
	}
#if 0
	if(p = strrchr(szName, '\\')) {
	    strcpy(commondir, szName);
	    if(p = strrchr(commondir, '\\'))
		*p = 0;
	}
#endif
	strcpy(dst, szName);
	return(1);
}

void	alert_beep(void)
{
	MessageBeep(MB_ICONHAND);
}

void	enter_beep(void)
{
	MessageBeep(MB_OK);
}
