
// exception.h [pengine]

// Copyright 2004 Jon Langridge, jon at positro.net
// License: GPL version 2 (see included gpl.txt)



class PException : public std::exception
{
public:
	const char *what () const throw ()
	{
		return "Unknown / generic";
	}
};


class PUserException : public PException
{
public:
	const char *what () const throw ()
	{
		return "Application error";
	}
};


class PFileException : public PException
{
public:
	const char *what () const throw ()
	{
		return "File not found, or could not be processed";
	}
};


class PParseException : public PException
{
public:
	const char *what () const throw ()
	{
		return "Parsing failed, possibly invalid format";
	}
};

